/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.exmo.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exmo.dto.trade.ExmoUserTrades;
import org.knowm.xchange.exmo.service.BaseExmoService;
import org.knowm.xchange.exmo.service.ExmoAdapters;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class ExmoTradeServiceRaw
extends BaseExmoService {
    protected ExmoTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    protected String placeOrder(String type, BigDecimal price, CurrencyPair currencyPair, BigDecimal originalAmount) {
        Map map = this.exmo.orderCreate(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), ExmoAdapters.format(currencyPair), originalAmount, price, type);
        Boolean result = (Boolean)map.get("result");
        if (!result.booleanValue()) {
            throw new ExchangeException("Failed to place order: " + map.get("error"));
        }
        return map.get("order_id").toString();
    }

    public List<LimitOrder> openOrders() {
        Map<String, List<Map<String, String>>> map = this.exmo.userOpenOrders(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        for (String market : map.keySet()) {
            CurrencyPair currencyPair = ExmoTradeServiceRaw.adaptMarket(market);
            for (Map<String, String> order : map.get(market)) {
                Order.OrderType type = ExmoAdapters.adaptOrderType(order);
                BigDecimal amount = new BigDecimal(order.get("quantity"));
                String id = order.get("order_id");
                BigDecimal price = new BigDecimal(order.get("price"));
                Date created = DateUtils.fromUnixTime((long)Long.valueOf(order.get("created")));
                openOrders.add(new LimitOrder(type, amount, (Instrument)currencyPair, id, created, price));
            }
        }
        return openOrders;
    }

    public ExmoUserTrades userTrades(String orderId) {
        Map<String, Object> map = this.exmo.orderTrades(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
        ArrayList<UserTrade> userTrades = new ArrayList<UserTrade>();
        Boolean result = (Boolean)map.get("result");
        if (result != null && !result.booleanValue()) {
            return null;
        }
        BigDecimal originalAmount = new BigDecimal(map.get("out_amount").toString());
        for (Map tradeDatum : (List)map.get("trades")) {
            CurrencyPair market = ExmoTradeServiceRaw.adaptMarket(tradeDatum.get("pair").toString());
            HashMap<String, String> bodge = new HashMap<String, String>();
            for (String key : tradeDatum.keySet()) {
                bodge.put(key, tradeDatum.get(key).toString());
            }
            userTrades.add(ExmoAdapters.adaptTrade(bodge, market));
        }
        return new ExmoUserTrades(originalAmount, userTrades);
    }

    public List<UserTrade> trades(Integer limit, Long offset, Collection<CurrencyPair> currencyPairs) {
        ArrayList<String> markets = new ArrayList<String>();
        for (CurrencyPair currencyPair : currencyPairs) {
            markets.add(ExmoAdapters.format(currencyPair));
        }
        Map<String, List<Map<String, String>>> map = this.exmo.userTrades(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), StringUtils.join(markets, (String)","), offset, limit);
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        for (String market : map.keySet()) {
            for (Map<String, String> tradeDatum : map.get(market)) {
                trades.add(ExmoAdapters.adaptTrade(tradeDatum, ExmoTradeServiceRaw.adaptMarket(market)));
            }
        }
        Collections.sort(trades, (o1, o2) -> o2.getTimestamp().compareTo(o1.getTimestamp()));
        return trades;
    }
}

