/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.exmo.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exmo.service.BaseExmoService;
import org.knowm.xchange.exmo.service.ExmoAdapters;

public class ExmoMarketDataServiceRaw
extends BaseExmoService {
    protected ExmoMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<CurrencyPair, Ticker> tickers() throws IOException {
        Map<String, Map<String, String>> tickers = this.exmo.ticker();
        HashMap<CurrencyPair, Ticker> results = new HashMap<CurrencyPair, Ticker>();
        for (String market : tickers.keySet()) {
            CurrencyPair currencyPair = ExmoMarketDataServiceRaw.adaptMarket(market);
            Ticker ticker = ExmoAdapters.adaptTicker(currencyPair, tickers.get(market));
            results.put(ticker.getCurrencyPair(), ticker);
        }
        return results;
    }

    public OrderBook orderBook(CurrencyPair currencyPair) throws IOException {
        String market = ExmoAdapters.format(currencyPair);
        Map<String, Map<String, Object>> map = this.exmo.orderBook(market);
        Map<String, Object> orderBookData = map.get(market);
        List<LimitOrder> asks = ExmoAdapters.adaptOrders(currencyPair, orderBookData, Order.OrderType.ASK);
        List<LimitOrder> bids = ExmoAdapters.adaptOrders(currencyPair, orderBookData, Order.OrderType.BID);
        return new OrderBook(null, asks, bids);
    }

    public void updateMetadata(ExchangeMetaData exchangeMetaData) throws IOException {
        Map currencyPairs = exchangeMetaData.getInstruments();
        Map currencies = exchangeMetaData.getCurrencies();
        Map<String, Map<String, String>> map = this.exmo.pairSettings();
        for (String marketName : map.keySet()) {
            CurrencyPair currencyPair = ExmoMarketDataServiceRaw.adaptMarket(marketName);
            Map<String, String> data = map.get(marketName);
            Integer priceScale = null;
            BigDecimal tradingFee = null;
            if (currencyPairs.containsKey(currencyPair)) {
                priceScale = ((InstrumentMetaData)currencyPairs.get(currencyPair)).getPriceScale();
                tradingFee = ((InstrumentMetaData)currencyPairs.get(currencyPair)).getTradingFee();
            }
            InstrumentMetaData staticMeta = (InstrumentMetaData)currencyPairs.get(currencyPair);
            currencyPairs.put(currencyPair, new InstrumentMetaData.Builder().tradingFee(tradingFee).minimumAmount(new BigDecimal(data.get("min_quantity"))).maximumAmount(new BigDecimal(data.get("max_quantity"))).priceScale(priceScale).feeTiers(staticMeta != null ? staticMeta.getFeeTiers() : null).build());
            if (!currencies.containsKey(currencyPair.base)) {
                currencies.put(currencyPair.base, new CurrencyMetaData(Integer.valueOf(8), null));
            }
            if (currencies.containsKey(currencyPair.counter)) continue;
            currencies.put(currencyPair.counter, new CurrencyMetaData(Integer.valueOf(8), null));
        }
    }

    public Trades trades(CurrencyPair ... currencyPairs) {
        return this.trades(Arrays.asList(currencyPairs));
    }

    public Trades trades(Collection<CurrencyPair> currencyPairs) {
        HashMap<String, CurrencyPair> markets = new HashMap<String, CurrencyPair>();
        for (CurrencyPair currencyPair : currencyPairs) {
            String market = currencyPair.base + "_" + currencyPair.counter;
            markets.put(market, currencyPair);
        }
        String marketNames = StringUtils.join(markets.keySet(), (String)",");
        ArrayList<Trade> results = new ArrayList<Trade>();
        Map<String, List<Map>> tradesMap = this.exmo.trades(marketNames);
        for (String key : tradesMap.keySet()) {
            CurrencyPair currencyPair = (CurrencyPair)markets.get(key);
            List<Map> trades = tradesMap.get(key);
            for (Map tradeData : trades) {
                String id = tradeData.get("trade_id").toString();
                String type = tradeData.get("type").toString();
                String price = tradeData.get("price").toString();
                String quantity = tradeData.get("quantity").toString();
                String amount = tradeData.get("amount").toString();
                long unixTimestamp = Long.parseLong(tradeData.get("date").toString());
                results.add(new Trade.Builder().type(type.equalsIgnoreCase("sell") ? Order.OrderType.ASK : Order.OrderType.BID).originalAmount(new BigDecimal(quantity)).currencyPair(currencyPair).price(new BigDecimal(price)).timestamp(new Date(unixTimestamp * 1000L)).id(id).build());
            }
        }
        return new Trades(results);
    }
}

