/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.exmo.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exmo.service.BaseExmoService;
import org.knowm.xchange.exmo.service.ExmoAdapters;
import org.knowm.xchange.utils.DateUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class ExmoAccountServiceRaw
extends BaseExmoService {
    protected ExmoAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, String> depositAddresses() {
        return this.exmo.depositAddress(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public List<Balance> balances() {
        Map map = this.exmo.userInfo(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        Map balances = (Map)map.get("balances");
        Map reserved = (Map)map.get("reserved");
        ArrayList<Balance> results = new ArrayList<Balance>();
        for (String ccy : balances.keySet()) {
            results.add(ExmoAdapters.adaptBalance(balances, reserved, ccy));
        }
        return results;
    }

    public List<FundingRecord> getFundingHistory(Date since) throws IOException {
        Map<String, Object> response = this.exmo.walletHistory(this.signatureCreator, this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), since.getTime() / 1000L);
        ArrayList<FundingRecord> results = new ArrayList<FundingRecord>();
        for (Map item : (List)response.get("history")) {
            long time = Long.valueOf(item.get("dt").toString());
            String type = item.get("type").toString();
            String curr = item.get("curr").toString();
            String status = item.get("status").toString();
            String amount = item.get("amount").toString();
            String account = item.get("account").toString();
            String provider = item.get("provider").toString();
            String txid = item.get("txid").toString();
            String description = (account + " " + provider).trim();
            String address = null;
            if (account.startsWith(curr + ":")) {
                address = account.replace(curr + ":", "").trim();
            }
            FundingRecord.Status statusEnum = FundingRecord.Status.FAILED;
            if (status.equalsIgnoreCase("processing")) {
                statusEnum = FundingRecord.Status.PROCESSING;
            } else if (status.equalsIgnoreCase("paid")) {
                statusEnum = FundingRecord.Status.COMPLETE;
            } else if (status.equalsIgnoreCase("transferred")) {
                statusEnum = FundingRecord.Status.COMPLETE;
            } else if (status.equalsIgnoreCase("cancelled")) {
                statusEnum = FundingRecord.Status.CANCELLED;
            }
            FundingRecord fundingRecord = new FundingRecord(address, DateUtils.fromUnixTime((long)time), Currency.getInstance((String)curr), new BigDecimal(amount).abs(), null, txid, type.equalsIgnoreCase("deposit") ? FundingRecord.Type.DEPOSIT : FundingRecord.Type.WITHDRAWAL, statusEnum, null, null, description);
            results.add(fundingRecord);
        }
        return results;
    }
}

