/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.service;

import java.io.IOException;
import org.knowm.xchange.deribit.v2.DeribitAdapters;
import org.knowm.xchange.deribit.v2.DeribitExchange;
import org.knowm.xchange.deribit.v2.dto.DeribitException;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitOrderBook;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitTicker;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitTrades;
import org.knowm.xchange.deribit.v2.service.DeribitMarketDataServiceRaw;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DeribitMarketDataService
extends DeribitMarketDataServiceRaw
implements MarketDataService {
    public DeribitMarketDataService(DeribitExchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(Instrument instrument, Object ... args) throws IOException {
        DeribitTicker deribitTicker;
        String deribitInstrumentName = DeribitAdapters.adaptInstrumentName(instrument);
        try {
            deribitTicker = super.getDeribitTicker(deribitInstrumentName);
        }
        catch (DeribitException ex) {
            throw DeribitAdapters.adapt(ex);
        }
        return DeribitAdapters.adaptTicker(deribitTicker);
    }

    public OrderBook getOrderBook(Instrument instrument, Object ... args) throws IOException {
        DeribitOrderBook deribitOrderBook;
        String deribitInstrumentName = DeribitAdapters.adaptInstrumentName(instrument);
        try {
            deribitOrderBook = super.getDeribitOrderBook(deribitInstrumentName, null);
        }
        catch (DeribitException ex) {
            throw new ExchangeException((Throwable)((Object)ex));
        }
        return DeribitAdapters.adaptOrderBook(deribitOrderBook);
    }

    public Trades getTrades(Instrument instrument, Object ... args) throws IOException {
        DeribitTrades deribitTrades;
        String deribitInstrumentName = DeribitAdapters.adaptInstrumentName(instrument);
        try {
            deribitTrades = super.getLastTradesByInstrument(deribitInstrumentName, null, null, null, null, null);
        }
        catch (DeribitException ex) {
            throw new ExchangeException((Throwable)((Object)ex));
        }
        return DeribitAdapters.adaptTrades(deribitTrades, instrument);
    }
}

