/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.service;

import java.io.UnsupportedEncodingException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;
import si.mazi.rescu.SynchronizedValueFactory;

public class DeribitAuth
extends BaseParamsDigest {
    private final String clientId;
    private final SynchronizedValueFactory<Long> nonce;

    private DeribitAuth(String clientId, String clientSecret, SynchronizedValueFactory<Long> nonce) {
        super(clientSecret, "HmacSHA256");
        this.clientId = clientId;
        this.nonce = nonce;
    }

    public static DeribitAuth createDeribitAuth(String clientId, String clientSecret, SynchronizedValueFactory<Long> nonce) {
        return clientId == null || clientSecret == null ? null : new DeribitAuth(clientId, clientSecret, nonce);
    }

    public String digestParams(RestInvocation restInvocation) {
        String signature;
        String timestamp = "" + System.currentTimeMillis();
        String nonce = "" + this.nonce.createValue();
        String uri = restInvocation.getPath() + "?" + restInvocation.getQueryString();
        String body = restInvocation.getRequestBody();
        String httpMethod = restInvocation.getHttpMethod();
        String toSign = Stream.of(timestamp, nonce, httpMethod, uri, body).collect(Collectors.joining("\n", "", "\n"));
        try {
            signature = DigestUtils.bytesToHex((byte[])this.getMac().doFinal(toSign.getBytes("UTF-8"))).toLowerCase();
        }
        catch (UnsupportedEncodingException | IllegalStateException e) {
            throw new ExchangeException("Could not sign request", (Throwable)e);
        }
        return "deri-hmac-sha256 id=" + this.clientId + ",ts=" + timestamp + ",sig=" + signature + ",nonce=" + nonce;
    }
}

