/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.deribit.v2.DeribitAdapters;
import org.knowm.xchange.deribit.v2.DeribitExchange;
import org.knowm.xchange.deribit.v2.service.DeribitAccountServiceRaw;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.OpenPosition;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;

public class DeribitAccountService
extends DeribitAccountServiceRaw
implements AccountService {
    public DeribitAccountService(DeribitExchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        Wallet wallet = Wallet.Builder.from(this.balances()).build();
        return new AccountInfo(null, null, Collections.singleton(wallet), this.openPositions(), null);
    }

    List<Balance> balances() throws IOException {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (Currency c : this.currencies()) {
            balances.add(DeribitAdapters.adapt(super.getAccountSummary(c.getCurrencyCode(), false)));
        }
        return balances;
    }

    List<OpenPosition> openPositions() throws IOException {
        ArrayList<OpenPosition> openPositions = new ArrayList<OpenPosition>();
        for (Currency c : this.currencies()) {
            super.getPositions(c.getCurrencyCode(), null).stream().map(DeribitAdapters::adapt).forEach(openPositions::add);
        }
        return openPositions;
    }

    Collection<Currency> currencies() {
        return ((DeribitExchange)this.exchange).getExchangeMetaData().getCurrencies().keySet();
    }
}

