/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitGreeks;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitStats;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeribitOrderBook {
    private final TreeMap<BigDecimal, BigDecimal> bids = new TreeMap((k1, k2) -> -k1.compareTo((BigDecimal)k2));
    private final TreeMap<BigDecimal, BigDecimal> asks = new TreeMap();
    @JsonProperty(value="underlying_price")
    private BigDecimal underlyingPrice;
    @JsonProperty(value="underlying_index")
    private String underlyingIndex;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="stats")
    private DeribitStats stats;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="settlement_price")
    private BigDecimal settlementPrice;
    @JsonProperty(value="open_interest")
    private BigDecimal openInterest;
    @JsonProperty(value="min_price")
    private BigDecimal minPrice;
    @JsonProperty(value="max_price")
    private BigDecimal maxPrice;
    @JsonProperty(value="mark_price")
    private BigDecimal markPrice;
    @JsonProperty(value="mark_iv")
    private BigDecimal markIv;
    @JsonProperty(value="last_price")
    private BigDecimal lastPrice;
    @JsonProperty(value="interest_rate")
    private BigDecimal interestRate;
    @JsonProperty(value="instrument_name")
    private String instrumentName;
    @JsonProperty(value="index_price")
    private BigDecimal indexPrice;
    @JsonProperty(value="greeks")
    private DeribitGreeks greeks;
    @JsonProperty(value="delivery_price")
    private BigDecimal deliveryPrice;
    @JsonProperty(value="funding_8h")
    private BigDecimal funding8h;
    @JsonProperty(value="current_funding")
    private BigDecimal currentFunding;
    @JsonProperty(value="change_id")
    private long changeId;
    @JsonProperty(value="best_bid_price")
    private BigDecimal bestBidPrice;
    @JsonProperty(value="best_bid_amount")
    private BigDecimal bestBidAmount;
    @JsonProperty(value="best_ask_price")
    private BigDecimal bestAskPrice;
    @JsonProperty(value="best_ask_amount")
    private BigDecimal bestAskAmount;
    @JsonProperty(value="ask_iv")
    private BigDecimal askIv;
    @JsonProperty(value="bid_iv")
    private BigDecimal bidIv;

    @JsonProperty(value="bids")
    public void setBids(List<List<BigDecimal>> bids) {
        DeribitOrderBook.convertOrders(bids, this.bids);
    }

    @JsonProperty(value="asks")
    public void setAsks(List<List<BigDecimal>> asks) {
        DeribitOrderBook.convertOrders(asks, this.asks);
    }

    public Date getTimestamp() {
        return new Date(this.timestamp);
    }

    private static void convertOrders(List<List<BigDecimal>> from, TreeMap<BigDecimal, BigDecimal> to) {
        from.forEach(l -> to.put((BigDecimal)l.get(0), (BigDecimal)l.get(1)));
    }

    public TreeMap<BigDecimal, BigDecimal> getBids() {
        return this.bids;
    }

    public TreeMap<BigDecimal, BigDecimal> getAsks() {
        return this.asks;
    }

    public BigDecimal getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    public String getUnderlyingIndex() {
        return this.underlyingIndex;
    }

    public DeribitStats getStats() {
        return this.stats;
    }

    public String getState() {
        return this.state;
    }

    public BigDecimal getSettlementPrice() {
        return this.settlementPrice;
    }

    public BigDecimal getOpenInterest() {
        return this.openInterest;
    }

    public BigDecimal getMinPrice() {
        return this.minPrice;
    }

    public BigDecimal getMaxPrice() {
        return this.maxPrice;
    }

    public BigDecimal getMarkPrice() {
        return this.markPrice;
    }

    public BigDecimal getMarkIv() {
        return this.markIv;
    }

    public BigDecimal getLastPrice() {
        return this.lastPrice;
    }

    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    public String getInstrumentName() {
        return this.instrumentName;
    }

    public BigDecimal getIndexPrice() {
        return this.indexPrice;
    }

    public DeribitGreeks getGreeks() {
        return this.greeks;
    }

    public BigDecimal getDeliveryPrice() {
        return this.deliveryPrice;
    }

    public BigDecimal getFunding8h() {
        return this.funding8h;
    }

    public BigDecimal getCurrentFunding() {
        return this.currentFunding;
    }

    public long getChangeId() {
        return this.changeId;
    }

    public BigDecimal getBestBidPrice() {
        return this.bestBidPrice;
    }

    public BigDecimal getBestBidAmount() {
        return this.bestBidAmount;
    }

    public BigDecimal getBestAskPrice() {
        return this.bestAskPrice;
    }

    public BigDecimal getBestAskAmount() {
        return this.bestAskAmount;
    }

    public BigDecimal getAskIv() {
        return this.askIv;
    }

    public BigDecimal getBidIv() {
        return this.bidIv;
    }

    @JsonProperty(value="underlying_price")
    public void setUnderlyingPrice(BigDecimal underlyingPrice) {
        this.underlyingPrice = underlyingPrice;
    }

    @JsonProperty(value="underlying_index")
    public void setUnderlyingIndex(String underlyingIndex) {
        this.underlyingIndex = underlyingIndex;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="stats")
    public void setStats(DeribitStats stats) {
        this.stats = stats;
    }

    @JsonProperty(value="state")
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="settlement_price")
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    @JsonProperty(value="open_interest")
    public void setOpenInterest(BigDecimal openInterest) {
        this.openInterest = openInterest;
    }

    @JsonProperty(value="min_price")
    public void setMinPrice(BigDecimal minPrice) {
        this.minPrice = minPrice;
    }

    @JsonProperty(value="max_price")
    public void setMaxPrice(BigDecimal maxPrice) {
        this.maxPrice = maxPrice;
    }

    @JsonProperty(value="mark_price")
    public void setMarkPrice(BigDecimal markPrice) {
        this.markPrice = markPrice;
    }

    @JsonProperty(value="mark_iv")
    public void setMarkIv(BigDecimal markIv) {
        this.markIv = markIv;
    }

    @JsonProperty(value="last_price")
    public void setLastPrice(BigDecimal lastPrice) {
        this.lastPrice = lastPrice;
    }

    @JsonProperty(value="interest_rate")
    public void setInterestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
    }

    @JsonProperty(value="instrument_name")
    public void setInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
    }

    @JsonProperty(value="index_price")
    public void setIndexPrice(BigDecimal indexPrice) {
        this.indexPrice = indexPrice;
    }

    @JsonProperty(value="greeks")
    public void setGreeks(DeribitGreeks greeks) {
        this.greeks = greeks;
    }

    @JsonProperty(value="delivery_price")
    public void setDeliveryPrice(BigDecimal deliveryPrice) {
        this.deliveryPrice = deliveryPrice;
    }

    @JsonProperty(value="funding_8h")
    public void setFunding8h(BigDecimal funding8h) {
        this.funding8h = funding8h;
    }

    @JsonProperty(value="current_funding")
    public void setCurrentFunding(BigDecimal currentFunding) {
        this.currentFunding = currentFunding;
    }

    @JsonProperty(value="change_id")
    public void setChangeId(long changeId) {
        this.changeId = changeId;
    }

    @JsonProperty(value="best_bid_price")
    public void setBestBidPrice(BigDecimal bestBidPrice) {
        this.bestBidPrice = bestBidPrice;
    }

    @JsonProperty(value="best_bid_amount")
    public void setBestBidAmount(BigDecimal bestBidAmount) {
        this.bestBidAmount = bestBidAmount;
    }

    @JsonProperty(value="best_ask_price")
    public void setBestAskPrice(BigDecimal bestAskPrice) {
        this.bestAskPrice = bestAskPrice;
    }

    @JsonProperty(value="best_ask_amount")
    public void setBestAskAmount(BigDecimal bestAskAmount) {
        this.bestAskAmount = bestAskAmount;
    }

    @JsonProperty(value="ask_iv")
    public void setAskIv(BigDecimal askIv) {
        this.askIv = askIv;
    }

    @JsonProperty(value="bid_iv")
    public void setBidIv(BigDecimal bidIv) {
        this.bidIv = bidIv;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeribitOrderBook)) {
            return false;
        }
        DeribitOrderBook other = (DeribitOrderBook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        if (this.getChangeId() != other.getChangeId()) {
            return false;
        }
        TreeMap<BigDecimal, BigDecimal> this$bids = this.getBids();
        TreeMap<BigDecimal, BigDecimal> other$bids = other.getBids();
        if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
            return false;
        }
        TreeMap<BigDecimal, BigDecimal> this$asks = this.getAsks();
        TreeMap<BigDecimal, BigDecimal> other$asks = other.getAsks();
        if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
            return false;
        }
        BigDecimal this$underlyingPrice = this.getUnderlyingPrice();
        BigDecimal other$underlyingPrice = other.getUnderlyingPrice();
        if (this$underlyingPrice == null ? other$underlyingPrice != null : !((Object)this$underlyingPrice).equals(other$underlyingPrice)) {
            return false;
        }
        String this$underlyingIndex = this.getUnderlyingIndex();
        String other$underlyingIndex = other.getUnderlyingIndex();
        if (this$underlyingIndex == null ? other$underlyingIndex != null : !this$underlyingIndex.equals(other$underlyingIndex)) {
            return false;
        }
        DeribitStats this$stats = this.getStats();
        DeribitStats other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        BigDecimal this$settlementPrice = this.getSettlementPrice();
        BigDecimal other$settlementPrice = other.getSettlementPrice();
        if (this$settlementPrice == null ? other$settlementPrice != null : !((Object)this$settlementPrice).equals(other$settlementPrice)) {
            return false;
        }
        BigDecimal this$openInterest = this.getOpenInterest();
        BigDecimal other$openInterest = other.getOpenInterest();
        if (this$openInterest == null ? other$openInterest != null : !((Object)this$openInterest).equals(other$openInterest)) {
            return false;
        }
        BigDecimal this$minPrice = this.getMinPrice();
        BigDecimal other$minPrice = other.getMinPrice();
        if (this$minPrice == null ? other$minPrice != null : !((Object)this$minPrice).equals(other$minPrice)) {
            return false;
        }
        BigDecimal this$maxPrice = this.getMaxPrice();
        BigDecimal other$maxPrice = other.getMaxPrice();
        if (this$maxPrice == null ? other$maxPrice != null : !((Object)this$maxPrice).equals(other$maxPrice)) {
            return false;
        }
        BigDecimal this$markPrice = this.getMarkPrice();
        BigDecimal other$markPrice = other.getMarkPrice();
        if (this$markPrice == null ? other$markPrice != null : !((Object)this$markPrice).equals(other$markPrice)) {
            return false;
        }
        BigDecimal this$markIv = this.getMarkIv();
        BigDecimal other$markIv = other.getMarkIv();
        if (this$markIv == null ? other$markIv != null : !((Object)this$markIv).equals(other$markIv)) {
            return false;
        }
        BigDecimal this$lastPrice = this.getLastPrice();
        BigDecimal other$lastPrice = other.getLastPrice();
        if (this$lastPrice == null ? other$lastPrice != null : !((Object)this$lastPrice).equals(other$lastPrice)) {
            return false;
        }
        BigDecimal this$interestRate = this.getInterestRate();
        BigDecimal other$interestRate = other.getInterestRate();
        if (this$interestRate == null ? other$interestRate != null : !((Object)this$interestRate).equals(other$interestRate)) {
            return false;
        }
        String this$instrumentName = this.getInstrumentName();
        String other$instrumentName = other.getInstrumentName();
        if (this$instrumentName == null ? other$instrumentName != null : !this$instrumentName.equals(other$instrumentName)) {
            return false;
        }
        BigDecimal this$indexPrice = this.getIndexPrice();
        BigDecimal other$indexPrice = other.getIndexPrice();
        if (this$indexPrice == null ? other$indexPrice != null : !((Object)this$indexPrice).equals(other$indexPrice)) {
            return false;
        }
        DeribitGreeks this$greeks = this.getGreeks();
        DeribitGreeks other$greeks = other.getGreeks();
        if (this$greeks == null ? other$greeks != null : !((Object)this$greeks).equals(other$greeks)) {
            return false;
        }
        BigDecimal this$deliveryPrice = this.getDeliveryPrice();
        BigDecimal other$deliveryPrice = other.getDeliveryPrice();
        if (this$deliveryPrice == null ? other$deliveryPrice != null : !((Object)this$deliveryPrice).equals(other$deliveryPrice)) {
            return false;
        }
        BigDecimal this$funding8h = this.getFunding8h();
        BigDecimal other$funding8h = other.getFunding8h();
        if (this$funding8h == null ? other$funding8h != null : !((Object)this$funding8h).equals(other$funding8h)) {
            return false;
        }
        BigDecimal this$currentFunding = this.getCurrentFunding();
        BigDecimal other$currentFunding = other.getCurrentFunding();
        if (this$currentFunding == null ? other$currentFunding != null : !((Object)this$currentFunding).equals(other$currentFunding)) {
            return false;
        }
        BigDecimal this$bestBidPrice = this.getBestBidPrice();
        BigDecimal other$bestBidPrice = other.getBestBidPrice();
        if (this$bestBidPrice == null ? other$bestBidPrice != null : !((Object)this$bestBidPrice).equals(other$bestBidPrice)) {
            return false;
        }
        BigDecimal this$bestBidAmount = this.getBestBidAmount();
        BigDecimal other$bestBidAmount = other.getBestBidAmount();
        if (this$bestBidAmount == null ? other$bestBidAmount != null : !((Object)this$bestBidAmount).equals(other$bestBidAmount)) {
            return false;
        }
        BigDecimal this$bestAskPrice = this.getBestAskPrice();
        BigDecimal other$bestAskPrice = other.getBestAskPrice();
        if (this$bestAskPrice == null ? other$bestAskPrice != null : !((Object)this$bestAskPrice).equals(other$bestAskPrice)) {
            return false;
        }
        BigDecimal this$bestAskAmount = this.getBestAskAmount();
        BigDecimal other$bestAskAmount = other.getBestAskAmount();
        if (this$bestAskAmount == null ? other$bestAskAmount != null : !((Object)this$bestAskAmount).equals(other$bestAskAmount)) {
            return false;
        }
        BigDecimal this$askIv = this.getAskIv();
        BigDecimal other$askIv = other.getAskIv();
        if (this$askIv == null ? other$askIv != null : !((Object)this$askIv).equals(other$askIv)) {
            return false;
        }
        BigDecimal this$bidIv = this.getBidIv();
        BigDecimal other$bidIv = other.getBidIv();
        return !(this$bidIv == null ? other$bidIv != null : !((Object)this$bidIv).equals(other$bidIv));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeribitOrderBook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        long $changeId = this.getChangeId();
        result = result * 59 + (int)($changeId >>> 32 ^ $changeId);
        TreeMap<BigDecimal, BigDecimal> $bids = this.getBids();
        result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
        TreeMap<BigDecimal, BigDecimal> $asks = this.getAsks();
        result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
        BigDecimal $underlyingPrice = this.getUnderlyingPrice();
        result = result * 59 + ($underlyingPrice == null ? 43 : ((Object)$underlyingPrice).hashCode());
        String $underlyingIndex = this.getUnderlyingIndex();
        result = result * 59 + ($underlyingIndex == null ? 43 : $underlyingIndex.hashCode());
        DeribitStats $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        BigDecimal $settlementPrice = this.getSettlementPrice();
        result = result * 59 + ($settlementPrice == null ? 43 : ((Object)$settlementPrice).hashCode());
        BigDecimal $openInterest = this.getOpenInterest();
        result = result * 59 + ($openInterest == null ? 43 : ((Object)$openInterest).hashCode());
        BigDecimal $minPrice = this.getMinPrice();
        result = result * 59 + ($minPrice == null ? 43 : ((Object)$minPrice).hashCode());
        BigDecimal $maxPrice = this.getMaxPrice();
        result = result * 59 + ($maxPrice == null ? 43 : ((Object)$maxPrice).hashCode());
        BigDecimal $markPrice = this.getMarkPrice();
        result = result * 59 + ($markPrice == null ? 43 : ((Object)$markPrice).hashCode());
        BigDecimal $markIv = this.getMarkIv();
        result = result * 59 + ($markIv == null ? 43 : ((Object)$markIv).hashCode());
        BigDecimal $lastPrice = this.getLastPrice();
        result = result * 59 + ($lastPrice == null ? 43 : ((Object)$lastPrice).hashCode());
        BigDecimal $interestRate = this.getInterestRate();
        result = result * 59 + ($interestRate == null ? 43 : ((Object)$interestRate).hashCode());
        String $instrumentName = this.getInstrumentName();
        result = result * 59 + ($instrumentName == null ? 43 : $instrumentName.hashCode());
        BigDecimal $indexPrice = this.getIndexPrice();
        result = result * 59 + ($indexPrice == null ? 43 : ((Object)$indexPrice).hashCode());
        DeribitGreeks $greeks = this.getGreeks();
        result = result * 59 + ($greeks == null ? 43 : ((Object)$greeks).hashCode());
        BigDecimal $deliveryPrice = this.getDeliveryPrice();
        result = result * 59 + ($deliveryPrice == null ? 43 : ((Object)$deliveryPrice).hashCode());
        BigDecimal $funding8h = this.getFunding8h();
        result = result * 59 + ($funding8h == null ? 43 : ((Object)$funding8h).hashCode());
        BigDecimal $currentFunding = this.getCurrentFunding();
        result = result * 59 + ($currentFunding == null ? 43 : ((Object)$currentFunding).hashCode());
        BigDecimal $bestBidPrice = this.getBestBidPrice();
        result = result * 59 + ($bestBidPrice == null ? 43 : ((Object)$bestBidPrice).hashCode());
        BigDecimal $bestBidAmount = this.getBestBidAmount();
        result = result * 59 + ($bestBidAmount == null ? 43 : ((Object)$bestBidAmount).hashCode());
        BigDecimal $bestAskPrice = this.getBestAskPrice();
        result = result * 59 + ($bestAskPrice == null ? 43 : ((Object)$bestAskPrice).hashCode());
        BigDecimal $bestAskAmount = this.getBestAskAmount();
        result = result * 59 + ($bestAskAmount == null ? 43 : ((Object)$bestAskAmount).hashCode());
        BigDecimal $askIv = this.getAskIv();
        result = result * 59 + ($askIv == null ? 43 : ((Object)$askIv).hashCode());
        BigDecimal $bidIv = this.getBidIv();
        result = result * 59 + ($bidIv == null ? 43 : ((Object)$bidIv).hashCode());
        return result;
    }

    public String toString() {
        return "DeribitOrderBook(bids=" + this.getBids() + ", asks=" + this.getAsks() + ", underlyingPrice=" + this.getUnderlyingPrice() + ", underlyingIndex=" + this.getUnderlyingIndex() + ", timestamp=" + this.getTimestamp() + ", stats=" + this.getStats() + ", state=" + this.getState() + ", settlementPrice=" + this.getSettlementPrice() + ", openInterest=" + this.getOpenInterest() + ", minPrice=" + this.getMinPrice() + ", maxPrice=" + this.getMaxPrice() + ", markPrice=" + this.getMarkPrice() + ", markIv=" + this.getMarkIv() + ", lastPrice=" + this.getLastPrice() + ", interestRate=" + this.getInterestRate() + ", instrumentName=" + this.getInstrumentName() + ", indexPrice=" + this.getIndexPrice() + ", greeks=" + this.getGreeks() + ", deliveryPrice=" + this.getDeliveryPrice() + ", funding8h=" + this.getFunding8h() + ", currentFunding=" + this.getCurrentFunding() + ", changeId=" + this.getChangeId() + ", bestBidPrice=" + this.getBestBidPrice() + ", bestBidAmount=" + this.getBestBidAmount() + ", bestAskPrice=" + this.getBestAskPrice() + ", bestAskAmount=" + this.getBestAskAmount() + ", askIv=" + this.getAskIv() + ", bidIv=" + this.getBidIv() + ")";
    }
}

