/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.knowm.xchange.deribit.v2.dto.DeribitError;
import si.mazi.rescu.ExceptionalReturnContentException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeribitResponse<V> {
    @JsonProperty(value="jsonrpc")
    private String jsonRPC;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="result")
    private V result;
    @JsonProperty(value="testnet")
    private boolean testnet;
    @JsonProperty(value="usIn")
    private long usIn;
    @JsonProperty(value="usOut")
    private long usOut;
    @JsonProperty(value="usDiff")
    private long usDiff;

    public DeribitResponse() {
    }

    public DeribitResponse(String jsonRPC, long id, V result, DeribitError error, boolean testnet, long usIn, long usOut, long usDiff) {
        if (error != null) {
            throw new ExceptionalReturnContentException("Error occurred");
        }
        this.jsonRPC = jsonRPC;
        this.id = id;
        this.result = result;
        this.testnet = testnet;
        this.usIn = usIn;
        this.usOut = usOut;
        this.usDiff = usDiff;
    }

    public String getJsonRPC() {
        return this.jsonRPC;
    }

    public long getId() {
        return this.id;
    }

    public V getResult() {
        return this.result;
    }

    public boolean isTestnet() {
        return this.testnet;
    }

    public long getUsIn() {
        return this.usIn;
    }

    public long getUsOut() {
        return this.usOut;
    }

    public long getUsDiff() {
        return this.usDiff;
    }

    @JsonProperty(value="jsonrpc")
    public void setJsonRPC(String jsonRPC) {
        this.jsonRPC = jsonRPC;
    }

    @JsonProperty(value="id")
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="result")
    public void setResult(V result) {
        this.result = result;
    }

    @JsonProperty(value="testnet")
    public void setTestnet(boolean testnet) {
        this.testnet = testnet;
    }

    @JsonProperty(value="usIn")
    public void setUsIn(long usIn) {
        this.usIn = usIn;
    }

    @JsonProperty(value="usOut")
    public void setUsOut(long usOut) {
        this.usOut = usOut;
    }

    @JsonProperty(value="usDiff")
    public void setUsDiff(long usDiff) {
        this.usDiff = usDiff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeribitResponse)) {
            return false;
        }
        DeribitResponse other = (DeribitResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isTestnet() != other.isTestnet()) {
            return false;
        }
        if (this.getUsIn() != other.getUsIn()) {
            return false;
        }
        if (this.getUsOut() != other.getUsOut()) {
            return false;
        }
        if (this.getUsDiff() != other.getUsDiff()) {
            return false;
        }
        String this$jsonRPC = this.getJsonRPC();
        String other$jsonRPC = other.getJsonRPC();
        if (this$jsonRPC == null ? other$jsonRPC != null : !this$jsonRPC.equals(other$jsonRPC)) {
            return false;
        }
        V this$result = this.getResult();
        V other$result = other.getResult();
        return !(this$result == null ? other$result != null : !this$result.equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeribitResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isTestnet() ? 79 : 97);
        long $usIn = this.getUsIn();
        result = result * 59 + (int)($usIn >>> 32 ^ $usIn);
        long $usOut = this.getUsOut();
        result = result * 59 + (int)($usOut >>> 32 ^ $usOut);
        long $usDiff = this.getUsDiff();
        result = result * 59 + (int)($usDiff >>> 32 ^ $usDiff);
        String $jsonRPC = this.getJsonRPC();
        result = result * 59 + ($jsonRPC == null ? 43 : $jsonRPC.hashCode());
        V $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        return result;
    }

    public String toString() {
        return "DeribitResponse(jsonRPC=" + this.getJsonRPC() + ", id=" + this.getId() + ", result=" + this.getResult() + ", testnet=" + this.isTestnet() + ", usIn=" + this.getUsIn() + ", usOut=" + this.getUsOut() + ", usDiff=" + this.getUsDiff() + ")";
    }
}

