/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.deribit.v2.DeribitAdapters;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitCurrency;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitInstrument;
import org.knowm.xchange.deribit.v2.service.DeribitAccountService;
import org.knowm.xchange.deribit.v2.service.DeribitMarketDataService;
import org.knowm.xchange.deribit.v2.service.DeribitMarketDataServiceRaw;
import org.knowm.xchange.deribit.v2.service.DeribitTradeService;

public class DeribitExchange
extends BaseExchange
implements Exchange {
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
    }

    protected void initServices() {
        this.marketDataService = new DeribitMarketDataService(this);
        this.accountService = new DeribitAccountService(this);
        this.tradeService = new DeribitTradeService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://www.deribit.com");
        exchangeSpecification.setHost("deribit.com");
        exchangeSpecification.setExchangeName("Deribit");
        exchangeSpecification.setExchangeDescription("Deribit is a Bitcoin futures exchange");
        return exchangeSpecification;
    }

    public ExchangeSpecification getSandboxExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://test.deribit.com/");
        exchangeSpecification.setHost("test.deribit.com");
        return exchangeSpecification;
    }

    public void remoteInit() throws IOException {
        this.updateExchangeMetaData();
    }

    public void updateExchangeMetaData() throws IOException {
        Map currencies = this.exchangeMetaData.getCurrencies();
        Map instruments = this.exchangeMetaData.getInstruments();
        List<DeribitCurrency> activeDeribitCurrencies = ((DeribitMarketDataServiceRaw)this.marketDataService).getDeribitCurrencies();
        currencies.clear();
        instruments.clear();
        for (DeribitCurrency deribitCurrency : activeDeribitCurrencies) {
            currencies.put(new Currency(deribitCurrency.getCurrency()), DeribitAdapters.adaptMeta(deribitCurrency));
            List<DeribitInstrument> deribitInstruments = ((DeribitMarketDataServiceRaw)this.marketDataService).getDeribitInstruments(deribitCurrency.getCurrency(), null, null);
            for (DeribitInstrument deribitInstrument : deribitInstruments) {
                instruments.put(DeribitAdapters.adaptFuturesContract(deribitInstrument), DeribitAdapters.adaptMeta(deribitInstrument));
            }
        }
    }
}

