/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.deribit.v2.dto.DeribitException;
import org.knowm.xchange.deribit.v2.dto.DeribitResponse;
import org.knowm.xchange.deribit.v2.dto.Kind;
import org.knowm.xchange.deribit.v2.dto.account.AccountSummary;
import org.knowm.xchange.deribit.v2.dto.account.Position;
import org.knowm.xchange.deribit.v2.dto.trade.AdvancedOptions;
import org.knowm.xchange.deribit.v2.dto.trade.Order;
import org.knowm.xchange.deribit.v2.dto.trade.OrderPlacement;
import org.knowm.xchange.deribit.v2.dto.trade.OrderType;
import org.knowm.xchange.deribit.v2.dto.trade.SettlementType;
import org.knowm.xchange.deribit.v2.dto.trade.TimeInForce;
import org.knowm.xchange.deribit.v2.dto.trade.Trigger;
import org.knowm.xchange.deribit.v2.dto.trade.UserSettlements;
import org.knowm.xchange.deribit.v2.dto.trade.UserTrades;
import si.mazi.rescu.ParamsDigest;

@Path(value="/api/v2/private")
@Produces(value={"application/json"})
public interface DeribitAuthenticated {
    @GET
    @Path(value="get_account_summary")
    public DeribitResponse<AccountSummary> getAccountSummary(@QueryParam(value="currency") String var1, @QueryParam(value="extended") Boolean var2, @HeaderParam(value="Authorization") ParamsDigest var3) throws DeribitException, IOException;

    @GET
    @Path(value="buy")
    public DeribitResponse<OrderPlacement> buy(@QueryParam(value="instrument_name") String var1, @QueryParam(value="amount") BigDecimal var2, @QueryParam(value="type") OrderType var3, @QueryParam(value="label") String var4, @QueryParam(value="price") BigDecimal var5, @QueryParam(value="time_in_force") TimeInForce var6, @QueryParam(value="max_show") BigDecimal var7, @QueryParam(value="post_only") Boolean var8, @QueryParam(value="reject_post_only") Boolean var9, @QueryParam(value="reduce_only") Boolean var10, @QueryParam(value="trigger_price") BigDecimal var11, @QueryParam(value="trigger") Trigger var12, @QueryParam(value="advanced") AdvancedOptions var13, @QueryParam(value="mmp") Boolean var14, @HeaderParam(value="Authorization") ParamsDigest var15) throws DeribitException, IOException;

    @GET
    @Path(value="sell")
    public DeribitResponse<OrderPlacement> sell(@QueryParam(value="instrument_name") String var1, @QueryParam(value="amount") BigDecimal var2, @QueryParam(value="type") OrderType var3, @QueryParam(value="label") String var4, @QueryParam(value="price") BigDecimal var5, @QueryParam(value="time_in_force") TimeInForce var6, @QueryParam(value="max_show") BigDecimal var7, @QueryParam(value="post_only") Boolean var8, @QueryParam(value="reject_post_only") Boolean var9, @QueryParam(value="reduce_only") Boolean var10, @QueryParam(value="trigger_price") BigDecimal var11, @QueryParam(value="trigger") Trigger var12, @QueryParam(value="advanced") AdvancedOptions var13, @QueryParam(value="mmp") Boolean var14, @HeaderParam(value="Authorization") ParamsDigest var15) throws DeribitException, IOException;

    @GET
    @Path(value="edit")
    public DeribitResponse<OrderPlacement> edit(@QueryParam(value="order_id") String var1, @QueryParam(value="amount") BigDecimal var2, @QueryParam(value="price") BigDecimal var3, @QueryParam(value="post_only") Boolean var4, @QueryParam(value="reject_post_only") Boolean var5, @QueryParam(value="reduce_only") Boolean var6, @QueryParam(value="trigger_price") BigDecimal var7, @QueryParam(value="advanced") AdvancedOptions var8, @QueryParam(value="mmp") Boolean var9, @HeaderParam(value="Authorization") ParamsDigest var10) throws DeribitException, IOException;

    @GET
    @Path(value="cancel")
    public DeribitResponse<Order> cancel(@QueryParam(value="order_id") String var1, @HeaderParam(value="Authorization") ParamsDigest var2) throws DeribitException, IOException;

    @GET
    @Path(value="cancel_by_label")
    public DeribitResponse<Integer> cancelByLabel(@QueryParam(value="label") String var1, @HeaderParam(value="Authorization") ParamsDigest var2) throws DeribitException, IOException;

    @GET
    @Path(value="cancel_all")
    public DeribitResponse<Integer> cancelAll(@HeaderParam(value="Authorization") ParamsDigest var1) throws DeribitException, IOException;

    @GET
    @Path(value="get_open_orders_by_currency")
    public DeribitResponse<List<Order>> getOpenOrdersByCurrency(@QueryParam(value="currency") String var1, @QueryParam(value="kind") Kind var2, @QueryParam(value="type") String var3, @HeaderParam(value="Authorization") ParamsDigest var4) throws DeribitException, IOException;

    @GET
    @Path(value="get_open_orders_by_instrument")
    public DeribitResponse<List<Order>> getOpenOrdersByInstrument(@QueryParam(value="instrument_name") String var1, @QueryParam(value="type") String var2, @HeaderParam(value="Authorization") ParamsDigest var3) throws DeribitException, IOException;

    @GET
    @Path(value="get_user_trades_by_currency")
    public DeribitResponse<UserTrades> getUserTradesByCurrency(@QueryParam(value="currency") String var1, @QueryParam(value="kind") Kind var2, @QueryParam(value="start_id") String var3, @QueryParam(value="end_id") String var4, @QueryParam(value="count") Integer var5, @QueryParam(value="include_old") Boolean var6, @QueryParam(value="sorting") String var7, @HeaderParam(value="Authorization") ParamsDigest var8) throws DeribitException, IOException;

    @GET
    @Path(value="get_user_trades_by_currency")
    public DeribitResponse<UserTrades> getUserTradesByCurrencyAndTime(@QueryParam(value="currency") String var1, @QueryParam(value="kind") Kind var2, @QueryParam(value="start_timestamp") long var3, @QueryParam(value="end_timestamp") long var5, @QueryParam(value="count") Integer var7, @QueryParam(value="include_old") Boolean var8, @QueryParam(value="sorting") String var9, @HeaderParam(value="Authorization") ParamsDigest var10) throws DeribitException, IOException;

    @GET
    @Path(value="get_user_trades_by_instrument")
    public DeribitResponse<UserTrades> getUserTradesByInstrument(@QueryParam(value="instrument_name") String var1, @QueryParam(value="start_seq") Integer var2, @QueryParam(value="end_seq") Integer var3, @QueryParam(value="count") Integer var4, @QueryParam(value="include_old") Boolean var5, @QueryParam(value="sorting") String var6, @HeaderParam(value="Authorization") ParamsDigest var7) throws DeribitException, IOException;

    @GET
    @Path(value="get_user_trades_by_instrument_and_time")
    public DeribitResponse<UserTrades> getUserTradesByInstrumentAndTime(@QueryParam(value="instrument_name") String var1, @QueryParam(value="start_timestamp") long var2, @QueryParam(value="end_timestamp") long var4, @QueryParam(value="count") Integer var6, @QueryParam(value="include_old") Boolean var7, @QueryParam(value="sorting") String var8, @HeaderParam(value="Authorization") ParamsDigest var9) throws DeribitException, IOException;

    @GET
    @Path(value="get_positions")
    public DeribitResponse<List<Position>> getPositions(@QueryParam(value="currency") String var1, @QueryParam(value="kind") Kind var2, @HeaderParam(value="Authorization") ParamsDigest var3) throws DeribitException, IOException;

    @GET
    @Path(value="get_settlement_history_by_instrument")
    public DeribitResponse<UserSettlements> getSettlementHistoryByInstrument(@QueryParam(value="instrument_name") String var1, @QueryParam(value="type") SettlementType var2, @QueryParam(value="count") Integer var3, @QueryParam(value="continuation") String var4, @HeaderParam(value="Authorization") ParamsDigest var5) throws DeribitException, IOException;

    @GET
    @Path(value="get_order_history_by_instrument")
    public DeribitResponse<List<Order>> getOrderHistoryByCurrency(@QueryParam(value="currency") String var1, @QueryParam(value="kind") Kind var2, @QueryParam(value="count") Integer var3, @QueryParam(value="offset") Integer var4, @QueryParam(value="include_old") Boolean var5, @QueryParam(value="include_unfilled") Boolean var6, @HeaderParam(value="Authorization") ParamsDigest var7) throws DeribitException, IOException;

    @GET
    @Path(value="get_order_history_by_instrument")
    public DeribitResponse<List<Order>> getOrderHistoryByInstrument(@QueryParam(value="instrument_name") String var1, @QueryParam(value="count") Integer var2, @QueryParam(value="offset") Integer var3, @QueryParam(value="include_old") Boolean var4, @QueryParam(value="include_unfilled") Boolean var5, @HeaderParam(value="Authorization") ParamsDigest var6) throws DeribitException, IOException;

    @GET
    @Path(value="get_order_state")
    public DeribitResponse<Order> getOrderState(@QueryParam(value="order_id") String var1, @HeaderParam(value="Authorization") ParamsDigest var2) throws DeribitException, IOException;
}

