/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.deribit.v2.DeribitExchange;
import org.knowm.xchange.deribit.v2.dto.Kind;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitCurrency;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitInstrument;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitOrderBook;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitSummary;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitTicker;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitTrades;
import org.knowm.xchange.deribit.v2.service.DeribitBaseService;

public class DeribitMarketDataServiceRaw
extends DeribitBaseService {
    public DeribitMarketDataServiceRaw(DeribitExchange exchange) {
        super(exchange);
    }

    public List<DeribitInstrument> getDeribitInstruments(String currency, Kind kind, Boolean expired) throws IOException {
        return this.deribit.getInstruments(currency, kind, expired).getResult();
    }

    public List<DeribitCurrency> getDeribitCurrencies() throws IOException {
        return this.deribit.getCurrencies().getResult();
    }

    public DeribitOrderBook getDeribitOrderBook(String instrumentName, Integer depth) throws IOException {
        return this.deribit.getOrderBook(instrumentName, depth).getResult();
    }

    public List<List<BigDecimal>> getHistoricalVolatility(String currency) throws IOException {
        return this.deribit.getHistoricalVolatility(currency).getResult();
    }

    public DeribitTrades getLastTradesByInstrument(String instrumentName, Integer startSeq, Integer endSeq, Integer count, Boolean includeOld, String sorting) throws IOException {
        return this.deribit.getLastTradesByInstrument(instrumentName, startSeq, endSeq, count, includeOld, sorting).getResult();
    }

    public List<DeribitSummary> getSummaryByInstrument(String instrumentName) throws IOException {
        return this.deribit.getSummaryByInstrument(instrumentName).getResult();
    }

    public DeribitTicker getDeribitTicker(String instrumentName) throws IOException {
        return this.deribit.getTicker(instrumentName).getResult();
    }
}

