/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.service;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.deribit.v2.Deribit;
import org.knowm.xchange.deribit.v2.DeribitAuthenticated;
import org.knowm.xchange.deribit.v2.DeribitExchange;
import org.knowm.xchange.deribit.v2.dto.DeribitException;
import org.knowm.xchange.deribit.v2.dto.GrantType;
import org.knowm.xchange.deribit.v2.dto.account.DeribitAuthentication;
import org.knowm.xchange.deribit.v2.service.DeribitAuth;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class DeribitBaseService
extends BaseExchangeService<DeribitExchange>
implements BaseService {
    protected final Deribit deribit;
    protected final DeribitAuthenticated deribitAuthenticated;
    protected final DeribitAuth deribitAuth;
    private DeribitAuthentication deribitAuthentication;

    public DeribitBaseService(DeribitExchange exchange) {
        super((Exchange)exchange);
        this.deribit = (Deribit)ExchangeRestProxyBuilder.forInterface(Deribit.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.deribitAuthenticated = (DeribitAuthenticated)ExchangeRestProxyBuilder.forInterface(DeribitAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.deribitAuth = DeribitAuth.createDeribitAuth(exchange.getExchangeSpecification().getApiKey(), exchange.getExchangeSpecification().getSecretKey(), (SynchronizedValueFactory<Long>)exchange.getNonceFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParamsDigest getDeribitAuthentication() throws DeribitException, IOException {
        DeribitAuthentication auth = this.deribitAuthentication;
        if (auth != null && auth.valid()) {
            return auth;
        }
        DeribitBaseService deribitBaseService = this;
        synchronized (deribitBaseService) {
            auth = this.deribitAuthentication;
            if (auth != null && auth.valid()) {
                return auth;
            }
            this.deribitAuthentication = auth = this.authOverClientSignature(((DeribitExchange)this.exchange).getExchangeSpecification().getApiKey(), ((DeribitExchange)this.exchange).getExchangeSpecification().getSecretKey());
        }
        return auth;
    }

    private DeribitAuthentication authOverClientCredentials(String clientId, String clientSecret) throws DeribitException, IOException {
        return this.deribit.auth(GrantType.client_credentials, null, null, clientId, clientSecret, null, null, null, null, null, null).getResult();
    }

    private DeribitAuthentication authOverClientSignature(String clientId, String clientSecret) throws DeribitException, IOException {
        String timestamp;
        Mac mac;
        if (clientId == null || clientId.isEmpty()) {
            throw new ExchangeSecurityException("API key must not be empty.");
        }
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new ExchangeException("API secret must not be empty.");
        }
        try {
            mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(clientSecret.getBytes("UTF-8"), "HmacSHA256");
            mac.init(secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ExchangeException("Invalid API secret", (Throwable)e);
        }
        String nonce = timestamp = "" + System.currentTimeMillis();
        String data = "";
        String toSign = timestamp + "\n" + nonce + "\n" + data;
        String signature = DigestUtils.bytesToHex((byte[])mac.doFinal(toSign.getBytes("UTF-8"))).toLowerCase();
        return this.deribit.auth(GrantType.client_signature, null, null, clientId, null, null, timestamp, signature, nonce, null, null).getResult();
    }

    public DeribitAuth getDeribitAuth() {
        return this.deribitAuth;
    }
}

