/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2.dto.account;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeribitAuthentication
implements ParamsDigest {
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="refresh_token")
    private String refreshToken;
    @JsonProperty(value="expires_in")
    private long expiresIn;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="state")
    private String state;
    private final long created = System.currentTimeMillis();

    public boolean valid() {
        return System.currentTimeMillis() < this.created + (this.expiresIn - 5L) * 1000L;
    }

    public String digestParams(RestInvocation restInvocation) {
        return "Bearer " + this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getState() {
        return this.state;
    }

    public long getCreated() {
        return this.created;
    }

    @JsonProperty(value="token_type")
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @JsonProperty(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    @JsonProperty(value="refresh_token")
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonProperty(value="expires_in")
    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @JsonProperty(value="access_token")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @JsonProperty(value="state")
    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeribitAuthentication)) {
            return false;
        }
        DeribitAuthentication other = (DeribitAuthentication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiresIn() != other.getExpiresIn()) {
            return false;
        }
        if (this.getCreated() != other.getCreated()) {
            return false;
        }
        String this$tokenType = this.getTokenType();
        String other$tokenType = other.getTokenType();
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeribitAuthentication;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiresIn = this.getExpiresIn();
        result = result * 59 + (int)($expiresIn >>> 32 ^ $expiresIn);
        long $created = this.getCreated();
        result = result * 59 + (int)($created >>> 32 ^ $created);
        String $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    public String toString() {
        return "DeribitAuthentication(tokenType=" + this.getTokenType() + ", scope=" + this.getScope() + ", refreshToken=" + this.getRefreshToken() + ", expiresIn=" + this.getExpiresIn() + ", accessToken=" + this.getAccessToken() + ", state=" + this.getState() + ", created=" + this.getCreated() + ")";
    }
}

