/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.deribit.v2;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.deribit.v2.dto.DeribitException;
import org.knowm.xchange.deribit.v2.dto.DeribitResponse;
import org.knowm.xchange.deribit.v2.dto.GrantType;
import org.knowm.xchange.deribit.v2.dto.Kind;
import org.knowm.xchange.deribit.v2.dto.account.DeribitAuthentication;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitCurrency;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitInstrument;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitOrderBook;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitSummary;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitTicker;
import org.knowm.xchange.deribit.v2.dto.marketdata.DeribitTrades;

@Path(value="/api/v2/public")
@Produces(value={"application/json"})
public interface Deribit {
    @GET
    @Path(value="get_instruments")
    public DeribitResponse<List<DeribitInstrument>> getInstruments(@QueryParam(value="currency") String var1, @QueryParam(value="kind") Kind var2, @QueryParam(value="expired") Boolean var3) throws DeribitException, IOException;

    @GET
    @Path(value="get_currencies")
    public DeribitResponse<List<DeribitCurrency>> getCurrencies() throws DeribitException, IOException;

    @GET
    @Path(value="get_order_book")
    public DeribitResponse<DeribitOrderBook> getOrderBook(@QueryParam(value="instrument_name") String var1, @QueryParam(value="depth") Integer var2) throws DeribitException, IOException;

    @GET
    @Path(value="get_historical_volatility")
    public DeribitResponse<List<List<BigDecimal>>> getHistoricalVolatility(@QueryParam(value="currency") String var1) throws DeribitException, IOException;

    @GET
    @Path(value="get_last_trades_by_instrument")
    public DeribitResponse<DeribitTrades> getLastTradesByInstrument(@QueryParam(value="instrument_name") String var1, @QueryParam(value="start_seq") Integer var2, @QueryParam(value="end_seq") Integer var3, @QueryParam(value="count") Integer var4, @QueryParam(value="include_old") Boolean var5, @QueryParam(value="sorting") String var6) throws DeribitException, IOException;

    @GET
    @Path(value="get_book_summary_by_instrument")
    public DeribitResponse<List<DeribitSummary>> getSummaryByInstrument(@QueryParam(value="instrument_name") String var1) throws DeribitException, IOException;

    @GET
    @Path(value="ticker")
    public DeribitResponse<DeribitTicker> getTicker(@QueryParam(value="instrument_name") String var1) throws DeribitException, IOException;

    @GET
    @Path(value="auth")
    public DeribitResponse<DeribitAuthentication> auth(@QueryParam(value="grant_type") GrantType var1, @QueryParam(value="username") String var2, @QueryParam(value="password") String var3, @QueryParam(value="client_id") String var4, @QueryParam(value="client_secret") String var5, @QueryParam(value="refresh_token") String var6, @QueryParam(value="timestamp") String var7, @QueryParam(value="signature") String var8, @QueryParam(value="nonce") String var9, @QueryParam(value="state") String var10, @QueryParam(value="scope") String var11) throws DeribitException, IOException;
}

