/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinone.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinone.dto.CoinoneException;
import org.knowm.xchange.coinone.dto.trade.CoinoneOrderInfoRequest;
import org.knowm.xchange.coinone.dto.trade.CoinoneOrderInfoResponse;
import org.knowm.xchange.coinone.dto.trade.CoinoneTradeCancelRequest;
import org.knowm.xchange.coinone.dto.trade.CoinoneTradeRequest;
import org.knowm.xchange.coinone.dto.trade.CoinoneTradeResponse;
import org.knowm.xchange.coinone.service.CoinoneBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;

public class CoinoneTradeServiceRaw
extends CoinoneBaseService {
    public CoinoneTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CoinoneTradeResponse placeLimitOrderRaw(LimitOrder limitOrder) throws CoinoneException, IOException {
        CoinoneTradeRequest request = new CoinoneTradeRequest(this.apiKey, (Long)this.exchange.getNonceFactory().createValue(), limitOrder.getLimitPrice(), limitOrder.getOriginalAmount(), limitOrder.getCurrencyPair().base);
        if (limitOrder.getType().equals((Object)Order.OrderType.ASK)) {
            return this.coinone.limitSell(this.payloadCreator, this.signatureCreator, request);
        }
        return this.coinone.limitBuy(this.payloadCreator, this.signatureCreator, request);
    }

    public CoinoneTradeResponse cancerOrder(CoinoneTradeCancelRequest orderParams) throws CoinoneException, IOException {
        if (orderParams.getAccessTocken() == null || orderParams.getNonce() == null) {
            orderParams.setAccessTocken(this.apiKey);
            orderParams.setNonce((Long)this.exchange.getNonceFactory().createValue());
        }
        return this.coinone.cancelOrder(this.payloadCreator, this.signatureCreator, orderParams);
    }

    public CoinoneOrderInfoResponse getOrderInfo(String orderId, CurrencyPair currencyPair) throws CoinoneException, IOException {
        CoinoneOrderInfoRequest request = new CoinoneOrderInfoRequest(this.apiKey, (Long)this.exchange.getNonceFactory().createValue(), orderId, currencyPair.base.getSymbol().toLowerCase());
        return this.coinone.getOrder(this.payloadCreator, this.signatureCreator, request);
    }
}

