/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinone.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinone.CoinoneAdapters;
import org.knowm.xchange.coinone.CoinoneExchange;
import org.knowm.xchange.coinone.service.CoinoneMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class CoinoneMarketDataService
extends CoinoneMarketDataServiceRaw
implements MarketDataService {
    public CoinoneMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return CoinoneAdapters.adaptTicker(super.getTicker(currencyPair));
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        return CoinoneAdapters.adaptOrderBook(this.getCoinoneOrderBook(currencyPair), currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        String period2 = "hour";
        if (args[0] != null) {
            try {
                period2 = CoinoneExchange.period.valueOf(args[0].toString()).name();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return CoinoneAdapters.adaptTrades(super.getTrades(currencyPair, period2), currencyPair);
    }
}

