/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinone.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Currency;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.trade.params.CancelOrderParams;

public class CoinoneTradeCancelRequest
implements CancelOrderParams {
    @JsonProperty(value="access_token")
    protected String accessTocken;
    @JsonProperty(value="nonce")
    protected Long nonce;
    @JsonProperty(value="order_id")
    protected String orderId;
    @JsonProperty(value="price")
    protected BigDecimal price;
    @JsonProperty(value="qty")
    protected BigDecimal qty;
    @JsonProperty(value="is_ask")
    protected boolean isAsk;
    @JsonProperty(value="currency")
    protected String currency;

    public CoinoneTradeCancelRequest(String orderId, BigDecimal price, BigDecimal qty, boolean isAsk, Currency currency) {
        this.orderId = orderId;
        this.price = price;
        this.qty = qty;
        this.isAsk = isAsk;
        this.currency = currency.getSymbol().toLowerCase();
    }

    public CoinoneTradeCancelRequest(String orderId, LimitOrder limitOrder) {
        this.orderId = orderId;
        this.price = limitOrder.getLimitPrice();
        this.qty = limitOrder.getOriginalAmount();
        this.isAsk = limitOrder.getType() == Order.OrderType.ASK;
        this.currency = limitOrder.getCurrencyPair().base.getSymbol().toLowerCase();
    }

    public String getAccessTocken() {
        return this.accessTocken;
    }

    public void setAccessTocken(String accessTocken) {
        this.accessTocken = accessTocken;
    }

    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public boolean isAsk() {
        return this.isAsk;
    }

    public void setAsk(boolean isAsk) {
        this.isAsk = isAsk;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }
}

