/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinone;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.coinone.dto.CoinoneException;
import org.knowm.xchange.coinone.dto.account.CoinoneBalancesResponse;
import org.knowm.xchange.coinone.dto.marketdata.CoinoneOrderBook;
import org.knowm.xchange.coinone.dto.marketdata.CoinoneOrderBookData;
import org.knowm.xchange.coinone.dto.marketdata.CoinoneTicker;
import org.knowm.xchange.coinone.dto.marketdata.CoinoneTradeData;
import org.knowm.xchange.coinone.dto.marketdata.CoinoneTrades;
import org.knowm.xchange.coinone.dto.trade.CoinoneOrderInfo;
import org.knowm.xchange.coinone.dto.trade.CoinoneOrderInfoResponse;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoinoneAdapters {
    public static final Logger log = LoggerFactory.getLogger(CoinoneAdapters.class);

    private CoinoneAdapters() {
    }

    public static OrderBook adaptOrderBook(CoinoneOrderBook coinoneOrderBook, CurrencyPair currencyPair) {
        if (!"0".equals(coinoneOrderBook.getErrorCode())) {
            throw new CoinoneException(coinoneOrderBook.getResult());
        }
        List<LimitOrder> asks = CoinoneAdapters.adaptMarketOrderToLimitOrder(coinoneOrderBook.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = CoinoneAdapters.adaptMarketOrderToLimitOrder(coinoneOrderBook.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(DateUtils.fromMillisUtc((long)(Long.valueOf(coinoneOrderBook.getTimestamp()) * 1000L)), asks, bids);
    }

    private static List<LimitOrder> adaptMarketOrderToLimitOrder(CoinoneOrderBookData[] coinoneOrders, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>(coinoneOrders.length);
        for (int i = 0; i < coinoneOrders.length; ++i) {
            CoinoneOrderBookData coinoneOrder = coinoneOrders[i];
            BigDecimal price = coinoneOrder.getPrice();
            BigDecimal amount = coinoneOrder.getQty();
            LimitOrder limitOrder = new LimitOrder(orderType, amount, (Instrument)currencyPair, null, null, price);
            orders.add(limitOrder);
        }
        return orders;
    }

    public static Order adaptOrderInfo(CoinoneOrderInfoResponse coinoneOrderInfoResponse) {
        ArrayList orders = new ArrayList();
        Order.OrderStatus status = Order.OrderStatus.NEW;
        status = coinoneOrderInfoResponse.getStatus().equals("live") ? Order.OrderStatus.NEW : (coinoneOrderInfoResponse.getStatus().equals("filled") ? Order.OrderStatus.FILLED : (coinoneOrderInfoResponse.getStatus().equals("partially_filled") ? Order.OrderStatus.PARTIALLY_FILLED : Order.OrderStatus.CANCELED));
        CoinoneOrderInfo orderInfo = coinoneOrderInfoResponse.getInfo();
        Order.OrderType type = orderInfo.getType().equals("ask") ? Order.OrderType.ASK : Order.OrderType.BID;
        BigDecimal originalAmount = orderInfo.getQty();
        CurrencyPair currencyPair = new CurrencyPair(new Currency(orderInfo.getCurrency().toUpperCase()), Currency.KRW);
        String orderId = orderInfo.getOrderId();
        BigDecimal cumulativeAmount = orderInfo.getQty().subtract(orderInfo.getRemainQty());
        BigDecimal price = orderInfo.getPrice();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(orderInfo.getTimestamp());
        LimitOrder order = new LimitOrder(type, originalAmount, (Instrument)currencyPair, orderId, cal.getTime(), price, price, cumulativeAmount, orderInfo.getFee(), status);
        return order;
    }

    public static Wallet adaptWallet(CoinoneBalancesResponse coninoneResponse) {
        if (!"0".equals(coninoneResponse.getErrorCode())) {
            throw new CoinoneException(coninoneResponse.getResult());
        }
        ArrayList<Balance> balances = new ArrayList<Balance>();
        balances.add(new Balance(Currency.getInstance((String)"KRW"), coninoneResponse.getKrw().getBalance(), coninoneResponse.getKrw().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"BCH"), coninoneResponse.getBch().getBalance(), coninoneResponse.getBch().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"BTG"), coninoneResponse.getBtg().getBalance(), coninoneResponse.getBtg().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"IOTA"), coninoneResponse.getIota().getBalance(), coninoneResponse.getIota().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"EOS"), coninoneResponse.getEos().getBalance(), coninoneResponse.getEos().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"OMG"), coninoneResponse.getOmg().getBalance(), coninoneResponse.getOmg().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"LTC"), coninoneResponse.getLtc().getBalance(), coninoneResponse.getLtc().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"BTC"), coninoneResponse.getBtc().getBalance(), coninoneResponse.getBtc().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"ETC"), coninoneResponse.getEtc().getBalance(), coninoneResponse.getEtc().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"ETH"), coninoneResponse.getEth().getBalance(), coninoneResponse.getEth().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"QTUM"), coninoneResponse.getQtum().getBalance(), coninoneResponse.getQtum().getAvail()));
        balances.add(new Balance(Currency.getInstance((String)"XRP"), coninoneResponse.getXrp().getBalance(), coninoneResponse.getXrp().getAvail()));
        return Wallet.Builder.from(balances).build();
    }

    public static Ticker adaptTicker(CoinoneTicker ticker) {
        CurrencyPair currencyPair = new CurrencyPair(Currency.getInstance((String)ticker.getCurrency()), Currency.KRW);
        Date date = DateUtils.fromMillisUtc((long)(Long.valueOf(ticker.getTimestamp()) * 1000L));
        return new Ticker.Builder().currencyPair(currencyPair).high(ticker.getHigh()).low(ticker.getLow()).last(ticker.getLast()).volume(ticker.getVolume()).open(ticker.getFirst()).timestamp(date).build();
    }

    public static Trades adaptTrades(CoinoneTrades trades, CurrencyPair currencyPair) {
        if (!"0".equals(trades.getErrorCode())) {
            throw new CoinoneException(trades.getResult());
        }
        ArrayList<Trade> tradeList = new ArrayList<Trade>(trades.getCompleteOrders().length);
        for (CoinoneTradeData trade : trades.getCompleteOrders()) {
            tradeList.add(CoinoneAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradeList, 0L, Trades.TradeSortType.SortByTimestamp);
    }

    private static Trade adaptTrade(CoinoneTradeData trade, CurrencyPair currencyPair) {
        return new Trade.Builder().originalAmount(trade.getQty()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(DateUtils.fromMillisUtc((long)(Long.parseLong(trade.getTimestamp()) * 1000L))).id("").build();
    }
}

