/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coindeal.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coindeal.CoindealAdapters;
import org.knowm.xchange.coindeal.CoindealErrorAdapter;
import org.knowm.xchange.coindeal.dto.CoindealException;
import org.knowm.xchange.coindeal.dto.trade.CoindealOrder;
import org.knowm.xchange.coindeal.dto.trade.CoindealTradeHistory;
import org.knowm.xchange.coindeal.service.CoindealBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;

public class CoindealTradeServiceRaw
extends CoindealBaseService {
    public CoindealTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<CoindealTradeHistory> getCoindealTradeHistory(CurrencyPair currencyPair, Integer limit) throws IOException {
        try {
            return this.coindeal.getTradeHistory(this.basicAuthentication, CoindealAdapters.adaptCurrencyPairToString(currencyPair), limit);
        }
        catch (CoindealException e) {
            throw CoindealErrorAdapter.adapt(e);
        }
    }

    public CoindealOrder placeOrder(LimitOrder limitOrder) throws IOException {
        try {
            return this.coindeal.placeOrder(this.basicAuthentication, CoindealAdapters.adaptCurrencyPairToString(limitOrder.getCurrencyPair()), CoindealAdapters.adaptOrderType(limitOrder.getType()), "limit", "GTC", limitOrder.getOriginalAmount().doubleValue(), limitOrder.getLimitPrice().doubleValue());
        }
        catch (CoindealException e) {
            throw CoindealErrorAdapter.adapt(e);
        }
    }

    public List<CoindealOrder> cancelCoindealOrders(CurrencyPair currencyPair) throws IOException {
        try {
            return this.coindeal.cancelOrders(this.basicAuthentication, CoindealAdapters.adaptCurrencyPairToString(currencyPair));
        }
        catch (CoindealException e) {
            throw CoindealErrorAdapter.adapt(e);
        }
    }

    public CoindealOrder cancelCoindealOrderById(String orderId) throws IOException {
        try {
            return this.coindeal.cancelOrderById(this.basicAuthentication, orderId);
        }
        catch (CoindealException e) {
            throw CoindealErrorAdapter.adapt(e);
        }
    }

    public List<CoindealOrder> getCoindealActiveOrders(CurrencyPair currencyPair) throws IOException {
        try {
            return this.coindeal.getActiveOrders(this.basicAuthentication, CoindealAdapters.adaptCurrencyPairToString(currencyPair));
        }
        catch (CoindealException e) {
            throw CoindealErrorAdapter.adapt(e);
        }
    }

    public CoindealOrder getCoindealOrderById(String orderId) throws IOException {
        try {
            return this.coindeal.getOrderById(this.basicAuthentication, orderId);
        }
        catch (CoindealException e) {
            throw CoindealErrorAdapter.adapt(e);
        }
    }
}

