/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coindeal;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.List;
import org.knowm.xchange.coindeal.Coindeal;
import org.knowm.xchange.coindeal.dto.account.CoindealBalance;
import org.knowm.xchange.coindeal.dto.trade.CoindealOrder;
import org.knowm.xchange.coindeal.dto.trade.CoindealTradeHistory;
import si.mazi.rescu.ParamsDigest;

@Path(value="api/")
@Produces(value={"application/json"})
public interface CoindealAuthenticated
extends Coindeal {
    public static final String HEADER_AUTH = "authorization";

    @GET
    @Path(value="v1/trading/balance")
    public List<CoindealBalance> getBalances(@HeaderParam(value="authorization") ParamsDigest var1) throws IOException;

    @GET
    @Path(value="v2/history/trades")
    public List<CoindealTradeHistory> getTradeHistory(@HeaderParam(value="authorization") ParamsDigest var1, @QueryParam(value="symbol") String var2, @QueryParam(value="limit") int var3) throws IOException;

    @GET
    @Path(value="v1/order")
    public List<CoindealOrder> getActiveOrders(@HeaderParam(value="authorization") ParamsDigest var1, @QueryParam(value="symbol") String var2) throws IOException;

    @POST
    @Path(value="v1/order")
    public CoindealOrder placeOrder(@HeaderParam(value="authorization") ParamsDigest var1, @FormParam(value="symbol") String var2, @FormParam(value="side") String var3, @FormParam(value="type") String var4, @FormParam(value="timeInForce") String var5, @FormParam(value="quantity") double var6, @FormParam(value="price") double var8) throws IOException;

    @DELETE
    @Path(value="v1/order")
    public List<CoindealOrder> cancelOrders(@HeaderParam(value="authorization") ParamsDigest var1, @FormParam(value="symbol") String var2) throws IOException;

    @DELETE
    @Path(value="v1/order/{clientOrderId}")
    public CoindealOrder cancelOrderById(@HeaderParam(value="authorization") ParamsDigest var1, @PathParam(value="clientOrderId") String var2) throws IOException;

    @GET
    @Path(value="v1/order/{clientOrderId}")
    public CoindealOrder getOrderById(@HeaderParam(value="authorization") ParamsDigest var1, @PathParam(value="clientOrderId") String var2) throws IOException;
}

