/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coincheck.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.utils.jackson.ISODateDeserializer;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonDeserialize(builder=CoincheckTradeBuilder.class)
public final class CoincheckTrade {
    @JsonProperty
    private final long id;
    @JsonProperty
    private final BigDecimal amount;
    @JsonProperty
    private final BigDecimal rate;
    @JsonProperty
    private final String pair;
    @JsonProperty
    private final String orderType;
    @JsonProperty
    @JsonDeserialize(using=ISODateDeserializer.class)
    private final Date createdAt;

    CoincheckTrade(long id, BigDecimal amount, BigDecimal rate, String pair, String orderType, Date createdAt) {
        this.id = id;
        this.amount = amount;
        this.rate = rate;
        this.pair = pair;
        this.orderType = orderType;
        this.createdAt = createdAt;
    }

    public static CoincheckTradeBuilder builder() {
        return new CoincheckTradeBuilder();
    }

    public long getId() {
        return this.id;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public String getPair() {
        return this.pair;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoincheckTrade)) {
            return false;
        }
        CoincheckTrade other = (CoincheckTrade)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
            return false;
        }
        String this$pair = this.getPair();
        String other$pair = other.getPair();
        if (this$pair == null ? other$pair != null : !this$pair.equals(other$pair)) {
            return false;
        }
        String this$orderType = this.getOrderType();
        String other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        String $pair = this.getPair();
        result = result * 59 + ($pair == null ? 43 : $pair.hashCode());
        String $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "CoincheckTrade(id=" + this.getId() + ", amount=" + this.getAmount() + ", rate=" + this.getRate() + ", pair=" + this.getPair() + ", orderType=" + this.getOrderType() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CoincheckTradeBuilder {
        private long id;
        private BigDecimal amount;
        private BigDecimal rate;
        private String pair;
        private String orderType;
        private Date createdAt;

        CoincheckTradeBuilder() {
        }

        @JsonProperty
        public CoincheckTradeBuilder id(long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        public CoincheckTradeBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty
        public CoincheckTradeBuilder rate(BigDecimal rate) {
            this.rate = rate;
            return this;
        }

        @JsonProperty
        public CoincheckTradeBuilder pair(String pair) {
            this.pair = pair;
            return this;
        }

        @JsonProperty
        public CoincheckTradeBuilder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        @JsonProperty
        @JsonDeserialize(using=ISODateDeserializer.class)
        public CoincheckTradeBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CoincheckTrade build() {
            return new CoincheckTrade(this.id, this.amount, this.rate, this.pair, this.orderType, this.createdAt);
        }

        public String toString() {
            return "CoincheckTrade.CoincheckTradeBuilder(id=" + this.id + ", amount=" + this.amount + ", rate=" + this.rate + ", pair=" + this.pair + ", orderType=" + this.orderType + ", createdAt=" + this.createdAt + ")";
        }
    }
}

