/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coincheck.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonDeserialize(builder=CoincheckTickerBuilder.class)
public final class CoincheckTicker {
    @JsonProperty
    private final BigDecimal last;
    @JsonProperty
    private final BigDecimal bid;
    @JsonProperty
    private final BigDecimal ask;
    @JsonProperty
    private final BigDecimal high;
    @JsonProperty
    private final BigDecimal low;
    @JsonProperty
    private final BigDecimal volume;
    @JsonProperty
    private final long timestamp;

    CoincheckTicker(BigDecimal last, BigDecimal bid, BigDecimal ask, BigDecimal high, BigDecimal low, BigDecimal volume, long timestamp) {
        this.last = last;
        this.bid = bid;
        this.ask = ask;
        this.high = high;
        this.low = low;
        this.volume = volume;
        this.timestamp = timestamp;
    }

    public static CoincheckTickerBuilder builder() {
        return new CoincheckTickerBuilder();
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoincheckTicker)) {
            return false;
        }
        CoincheckTicker other = (CoincheckTicker)o;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        BigDecimal this$last = this.getLast();
        BigDecimal other$last = other.getLast();
        if (this$last == null ? other$last != null : !((Object)this$last).equals(other$last)) {
            return false;
        }
        BigDecimal this$bid = this.getBid();
        BigDecimal other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        BigDecimal this$ask = this.getAsk();
        BigDecimal other$ask = other.getAsk();
        if (this$ask == null ? other$ask != null : !((Object)this$ask).equals(other$ask)) {
            return false;
        }
        BigDecimal this$high = this.getHigh();
        BigDecimal other$high = other.getHigh();
        if (this$high == null ? other$high != null : !((Object)this$high).equals(other$high)) {
            return false;
        }
        BigDecimal this$low = this.getLow();
        BigDecimal other$low = other.getLow();
        if (this$low == null ? other$low != null : !((Object)this$low).equals(other$low)) {
            return false;
        }
        BigDecimal this$volume = this.getVolume();
        BigDecimal other$volume = other.getVolume();
        return !(this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        BigDecimal $last = this.getLast();
        result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
        BigDecimal $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        BigDecimal $ask = this.getAsk();
        result = result * 59 + ($ask == null ? 43 : ((Object)$ask).hashCode());
        BigDecimal $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : ((Object)$high).hashCode());
        BigDecimal $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : ((Object)$low).hashCode());
        BigDecimal $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
        return result;
    }

    public String toString() {
        return "CoincheckTicker(last=" + this.getLast() + ", bid=" + this.getBid() + ", ask=" + this.getAsk() + ", high=" + this.getHigh() + ", low=" + this.getLow() + ", volume=" + this.getVolume() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CoincheckTickerBuilder {
        private BigDecimal last;
        private BigDecimal bid;
        private BigDecimal ask;
        private BigDecimal high;
        private BigDecimal low;
        private BigDecimal volume;
        private long timestamp;

        CoincheckTickerBuilder() {
        }

        @JsonProperty
        public CoincheckTickerBuilder last(BigDecimal last) {
            this.last = last;
            return this;
        }

        @JsonProperty
        public CoincheckTickerBuilder bid(BigDecimal bid) {
            this.bid = bid;
            return this;
        }

        @JsonProperty
        public CoincheckTickerBuilder ask(BigDecimal ask) {
            this.ask = ask;
            return this;
        }

        @JsonProperty
        public CoincheckTickerBuilder high(BigDecimal high) {
            this.high = high;
            return this;
        }

        @JsonProperty
        public CoincheckTickerBuilder low(BigDecimal low) {
            this.low = low;
            return this;
        }

        @JsonProperty
        public CoincheckTickerBuilder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        @JsonProperty
        public CoincheckTickerBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CoincheckTicker build() {
            return new CoincheckTicker(this.last, this.bid, this.ask, this.high, this.low, this.volume, this.timestamp);
        }

        public String toString() {
            return "CoincheckTicker.CoincheckTickerBuilder(last=" + this.last + ", bid=" + this.bid + ", ask=" + this.ask + ", high=" + this.high + ", low=" + this.low + ", volume=" + this.volume + ", timestamp=" + this.timestamp + ")";
        }
    }
}

