/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coincheck.dto.marketdata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Locale;
import org.knowm.xchange.coincheck.jackson.CoincheckPairDeserializer;
import org.knowm.xchange.coincheck.jackson.CoincheckPairSerializer;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

@JsonSerialize(using=CoincheckPairSerializer.class)
@JsonDeserialize(using=CoincheckPairDeserializer.class)
public final class CoincheckPair {
    private final CurrencyPair pair;

    public String toString() {
        return CoincheckPair.pairToString(this);
    }

    public static String pairToString(CoincheckPair pair) {
        String base = pair.getPair().base.toString().toLowerCase(Locale.ROOT);
        String counter = pair.getPair().counter.toString().toLowerCase(Locale.ROOT);
        return base + '_' + counter;
    }

    public static CoincheckPair stringToPair(String str) {
        String sanitized = str.replace("_", "");
        CurrencyPair pair = CurrencyPairDeserializer.getCurrencyPairFromString((String)sanitized);
        return new CoincheckPair(pair);
    }

    public static CoincheckPairBuilder builder() {
        return new CoincheckPairBuilder();
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoincheckPair)) {
            return false;
        }
        CoincheckPair other = (CoincheckPair)o;
        CurrencyPair this$pair = this.getPair();
        CurrencyPair other$pair = other.getPair();
        return !(this$pair == null ? other$pair != null : !this$pair.equals(other$pair));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CurrencyPair $pair = this.getPair();
        result = result * 59 + ($pair == null ? 43 : $pair.hashCode());
        return result;
    }

    public CoincheckPair(CurrencyPair pair) {
        this.pair = pair;
    }

    public static class CoincheckPairBuilder {
        private CurrencyPair pair;

        CoincheckPairBuilder() {
        }

        public CoincheckPairBuilder pair(CurrencyPair pair) {
            this.pair = pair;
            return this;
        }

        public CoincheckPair build() {
            return new CoincheckPair(this.pair);
        }

        public String toString() {
            return "CoincheckPair.CoincheckPairBuilder(pair=" + this.pair + ")";
        }
    }
}

