/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coincheck.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.List;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonDeserialize(builder=CoincheckOrderBookBuilder.class)
public final class CoincheckOrderBook {
    @JsonProperty
    private final List<List<BigDecimal>> bids;
    @JsonProperty
    private final List<List<BigDecimal>> asks;

    CoincheckOrderBook(List<List<BigDecimal>> bids, List<List<BigDecimal>> asks) {
        this.bids = bids;
        this.asks = asks;
    }

    public static CoincheckOrderBookBuilder builder() {
        return new CoincheckOrderBookBuilder();
    }

    public List<List<BigDecimal>> getBids() {
        return this.bids;
    }

    public List<List<BigDecimal>> getAsks() {
        return this.asks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoincheckOrderBook)) {
            return false;
        }
        CoincheckOrderBook other = (CoincheckOrderBook)o;
        List<List<BigDecimal>> this$bids = this.getBids();
        List<List<BigDecimal>> other$bids = other.getBids();
        if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
            return false;
        }
        List<List<BigDecimal>> this$asks = this.getAsks();
        List<List<BigDecimal>> other$asks = other.getAsks();
        return !(this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<BigDecimal>> $bids = this.getBids();
        result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
        List<List<BigDecimal>> $asks = this.getAsks();
        result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
        return result;
    }

    public String toString() {
        return "CoincheckOrderBook(bids=" + this.getBids() + ", asks=" + this.getAsks() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class CoincheckOrderBookBuilder {
        private List<List<BigDecimal>> bids;
        private List<List<BigDecimal>> asks;

        CoincheckOrderBookBuilder() {
        }

        @JsonProperty
        public CoincheckOrderBookBuilder bids(List<List<BigDecimal>> bids) {
            this.bids = bids;
            return this;
        }

        @JsonProperty
        public CoincheckOrderBookBuilder asks(List<List<BigDecimal>> asks) {
            this.asks = asks;
            return this;
        }

        public CoincheckOrderBook build() {
            return new CoincheckOrderBook(this.bids, this.asks);
        }

        public String toString() {
            return "CoincheckOrderBook.CoincheckOrderBookBuilder(bids=" + this.bids + ", asks=" + this.asks + ")";
        }
    }
}

