/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.service;

import java.io.IOException;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbaseProAdapters;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.CoinbasePagedResponse;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProException;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProFill;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProIdResponse;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProTradeHistoryParams;
import org.knowm.xchange.coinbasepro.service.CoinbaseProBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamTransactionId;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.utils.timestamp.UnixTimestampFactory;

public class CoinbaseProTradeServiceRaw
extends CoinbaseProBaseService {
    public CoinbaseProTradeServiceRaw(CoinbaseProExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public CoinbaseProOrder[] getCoinbaseProOpenOrders() throws IOException {
        try {
            return (CoinbaseProOrder[])this.decorateApiCall(() -> this.coinbasePro.getListOrders(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProOrder[] getCoinbaseProOpenOrders(String productId) throws IOException {
        try {
            return (CoinbaseProOrder[])this.decorateApiCall(() -> this.coinbasePro.getListOrders(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, "open", productId)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbasePagedResponse<CoinbaseProFill> getCoinbaseProFills(TradeHistoryParams tradeHistoryParams) throws IOException {
        TradeHistoryParamCurrencyPair ccyPairParams;
        CurrencyPair currencyPair;
        String orderId = null;
        String productId = null;
        Integer afterTradeId = null;
        Integer beforeTradeId = null;
        Integer limit = null;
        if (tradeHistoryParams instanceof CoinbaseProTradeHistoryParams) {
            CoinbaseProTradeHistoryParams historyParams = (CoinbaseProTradeHistoryParams)tradeHistoryParams;
            afterTradeId = historyParams.getAfterTradeId();
            beforeTradeId = historyParams.getBeforeTradeId();
        }
        if (tradeHistoryParams instanceof TradeHistoryParamTransactionId) {
            TradeHistoryParamTransactionId tnxIdParams = (TradeHistoryParamTransactionId)tradeHistoryParams;
            orderId = tnxIdParams.getTransactionId();
        }
        if (tradeHistoryParams instanceof TradeHistoryParamCurrencyPair && (currencyPair = (ccyPairParams = (TradeHistoryParamCurrencyPair)tradeHistoryParams).getCurrencyPair()) != null) {
            productId = CoinbaseProAdapters.adaptProductID(currencyPair);
        }
        if (tradeHistoryParams instanceof TradeHistoryParamLimit) {
            TradeHistoryParamLimit limitParams = (TradeHistoryParamLimit)tradeHistoryParams;
            limit = limitParams.getLimit();
        }
        try {
            return this.coinbasePro.getFills(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, afterTradeId, beforeTradeId, limit, orderId, productId);
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProIdResponse placeCoinbaseProOrder(CoinbaseProPlaceOrder order) throws IOException {
        try {
            return (CoinbaseProIdResponse)this.decorateApiCall(() -> this.coinbasePro.placeOrder(order, this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public boolean cancelCoinbaseProOrder(String id) throws IOException {
        try {
            return (Boolean)this.decorateApiCall(() -> {
                this.coinbasePro.cancelOrder(id, this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase);
                return true;
            }).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProOrder getOrder(String id) throws IOException {
        try {
            return (CoinbaseProOrder)this.decorateApiCall(() -> this.coinbasePro.getOrder(id, this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbasePagedResponse<CoinbaseProOrder> getOrders(String status, Integer limit, String after) throws IOException {
        try {
            return (CoinbasePagedResponse)this.decorateApiCall(() -> this.coinbasePro.getListOrders(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, status, limit, after)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }
}

