/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.service;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProException;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTrades;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProCandle;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProCurrency;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProduct;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBook;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductTicker;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProTrade;
import org.knowm.xchange.coinbasepro.service.CoinbaseProBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.InstrumentNotValidException;
import org.knowm.xchange.instrument.Instrument;

public class CoinbaseProMarketDataServiceRaw
extends CoinbaseProBaseService {
    public CoinbaseProMarketDataServiceRaw(CoinbaseProExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public CoinbaseProProductTicker getCoinbaseProProductTicker(CurrencyPair currencyPair) throws IOException {
        if (!this.checkProductExists((Instrument)currencyPair)) {
            throw new InstrumentNotValidException("Pair does not exist on CoinbasePro");
        }
        try {
            return (CoinbaseProProductTicker)this.decorateApiCall(() -> this.coinbasePro.getProductTicker(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode())).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProProductStats getCoinbaseProProductStats(CurrencyPair currencyPair) throws IOException {
        if (!this.checkProductExists((Instrument)currencyPair)) {
            throw new InstrumentNotValidException("Pair does not exist on CoinbasePro");
        }
        try {
            return (CoinbaseProProductStats)this.decorateApiCall(() -> this.coinbasePro.getProductStats(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode())).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public Map<String, CoinbaseProStats> getCoinbaseProStats() throws IOException {
        try {
            return (Map)this.decorateApiCall(this.coinbasePro::getStats).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProProductBook getCoinbaseProProductOrderBook(CurrencyPair currencyPair, int level) throws IOException {
        try {
            return (CoinbaseProProductBook)this.decorateApiCall(() -> this.coinbasePro.getProductOrderBook(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), String.valueOf(level))).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProTrade[] getCoinbaseProTrades(CurrencyPair currencyPair) throws IOException {
        try {
            return (CoinbaseProTrade[])this.decorateApiCall(() -> this.coinbasePro.getTrades(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode())).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProCandle[] getCoinbaseProHistoricalCandles(CurrencyPair currencyPair, String start, String end, String granularity) throws IOException {
        try {
            return (CoinbaseProCandle[])this.decorateApiCall(() -> this.coinbasePro.getHistoricalCandles(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), start, end, granularity)).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProProduct[] getCoinbaseProProducts() throws IOException {
        try {
            return (CoinbaseProProduct[])this.decorateApiCall(this.coinbasePro::getProducts).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProCurrency[] getCoinbaseProCurrencies() throws IOException {
        try {
            return (CoinbaseProCurrency[])this.decorateApiCall(this.coinbasePro::getCurrencies).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
        }
        catch (CoinbaseProException e) {
            throw this.handleError(e);
        }
    }

    public CoinbaseProTrades getCoinbaseProTradesExtended(CurrencyPair currencyPair, Long after, Integer limit) throws IOException {
        return (CoinbaseProTrades)this.decorateApiCall(() -> this.coinbasePro.getTradesPageable(currencyPair.base.getCurrencyCode(), currencyPair.counter.getCurrencyCode(), after, limit)).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call();
    }

    public boolean checkProductExists(Instrument currencyPair) {
        for (Instrument cp : ((CoinbaseProExchange)this.exchange).getExchangeInstruments()) {
            if (!cp.getBase().getCurrencyCode().equalsIgnoreCase(currencyPair.getBase().getCurrencyCode()) || !cp.getCounter().getCurrencyCode().equalsIgnoreCase(currencyPair.getCounter().getCurrencyCode())) continue;
            return true;
        }
        return false;
    }
}

