/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.service;

import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbasePro;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProException;
import org.knowm.xchange.coinbasepro.service.CoinbaseProDigest;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.FundsExceededException;
import org.knowm.xchange.exceptions.InternalServerException;
import org.knowm.xchange.exceptions.RateLimitExceededException;
import org.knowm.xchange.service.BaseResilientExchangeService;
import si.mazi.rescu.ParamsDigest;

public class CoinbaseProBaseService
extends BaseResilientExchangeService<CoinbaseProExchange> {
    protected final CoinbasePro coinbasePro;
    protected final ParamsDigest digest;
    protected final String apiKey;
    protected final String passphrase;

    protected CoinbaseProBaseService(CoinbaseProExchange exchange, ResilienceRegistries resilienceRegistries) {
        super((Exchange)exchange, resilienceRegistries);
        this.coinbasePro = (CoinbasePro)ExchangeRestProxyBuilder.forInterface(CoinbasePro.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.digest = CoinbaseProDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.passphrase = (String)exchange.getExchangeSpecification().getExchangeSpecificParametersItem("passphrase");
    }

    protected ExchangeException handleError(CoinbaseProException exception) {
        if (exception.getMessage().contains("Insufficient")) {
            return new FundsExceededException((Throwable)((Object)exception));
        }
        if (exception.getMessage().contains("Rate limit exceeded")) {
            return new RateLimitExceededException((Throwable)((Object)exception));
        }
        if (exception.getMessage().contains("Internal server error")) {
            return new InternalServerException((Throwable)((Object)exception));
        }
        return new ExchangeException((Throwable)((Object)exception));
    }
}

