/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbasePro;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProException;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTransfers;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProFee;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProSendMoneyRequest;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWebsocketAuthData;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWithdrawCryptoResponse;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProWithdrawFundsRequest;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProAccount;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProAccountAddress;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProSendMoneyResponse;
import org.knowm.xchange.coinbasepro.service.CoinbaseProBaseService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.utils.timestamp.UnixTimestampFactory;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public class CoinbaseProAccountServiceRaw
extends CoinbaseProBaseService {
    public CoinbaseProAccountServiceRaw(CoinbaseProExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount[] getCoinbaseProAccountInfo() throws CoinbaseProException, IOException {
        return (org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount[])this.decorateApiCall(() -> this.coinbasePro.getAccounts(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProFee getCoinbaseProFees() throws CoinbaseProException, IOException {
        return (CoinbaseProFee)this.decorateApiCall(() -> this.coinbasePro.getFees(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProSendMoneyResponse sendMoney(String accountId, String to, BigDecimal amount, Currency currency) throws CoinbaseProException, IOException {
        return (CoinbaseProSendMoneyResponse)this.decorateApiCall(() -> this.coinbasePro.sendMoney(new CoinbaseProSendMoneyRequest(to, amount, currency.getCurrencyCode()), this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, accountId)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProWithdrawCryptoResponse withdrawCrypto(String address, BigDecimal amount, Currency currency, String destinationTag, boolean noDestinationTag) throws CoinbaseProException, IOException {
        return (CoinbaseProWithdrawCryptoResponse)this.decorateApiCall(() -> this.coinbasePro.withdrawCrypto(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, new CoinbaseProWithdrawFundsRequest(amount, currency.getCurrencyCode(), address, destinationTag, noDestinationTag))).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public List<Map<?, ?>> ledger(String accountId, String startingOrderId) throws IOException {
        return (List)this.decorateApiCall(() -> this.coinbasePro.ledger(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, accountId, startingOrderId)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public String requestNewReport(CoinbasePro.CoinbaseProReportRequest reportRequest) throws IOException {
        return (String)this.decorateApiCall(() -> this.coinbasePro.createReport(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, reportRequest).get("id").toString()).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public Map<?, ?> report(String reportId) throws IOException {
        return (Map)this.decorateApiCall(() -> this.coinbasePro.getReport(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, reportId)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProTransfers transfers(String accountId, String profileId, int limit, String after) throws IOException {
        return (CoinbaseProTransfers)this.decorateApiCall(() -> this.coinbasePro.transfers(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, accountId, profileId, limit, after)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProTransfers transfers(String type, String profileId, String before, String after, int limit) throws IOException {
        return (CoinbaseProTransfers)this.decorateApiCall(() -> this.coinbasePro.transfers(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, type, profileId, before, after, limit)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProAccount[] getCoinbaseAccounts() throws IOException {
        return (CoinbaseProAccount[])this.decorateApiCall(() -> this.coinbasePro.getCoinbaseProAccounts(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProAccountAddress getCoinbaseAccountAddress(String accountId) throws IOException {
        return (CoinbaseProAccountAddress)this.decorateApiCall(() -> this.coinbasePro.getCoinbaseProAccountAddress(this.apiKey, this.digest, UnixTimestampFactory.INSTANCE.createValue(), this.passphrase, accountId)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
    }

    public CoinbaseProWebsocketAuthData getWebsocketAuthData() throws CoinbaseProException, IOException {
        long timestamp = UnixTimestampFactory.INSTANCE.createValue();
        WebhookAuthDataParamsDigestProxy digestProxy = new WebhookAuthDataParamsDigestProxy();
        JsonNode json = (JsonNode)this.decorateApiCall(() -> this.coinbasePro.getVerifyId(this.apiKey, digestProxy, timestamp, this.passphrase)).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call();
        String userId = json.get("id").asText();
        return new CoinbaseProWebsocketAuthData(userId, this.apiKey, this.passphrase, digestProxy.getSignature(), timestamp);
    }

    private class WebhookAuthDataParamsDigestProxy
    implements ParamsDigest {
        private String signature;

        private WebhookAuthDataParamsDigestProxy() {
        }

        public String digestParams(RestInvocation restInvocation) {
            this.signature = CoinbaseProAccountServiceRaw.this.digest.digestParams(restInvocation);
            return this.signature;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

