/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBookEntry;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBookEntryLevel1or2;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBookEntryLevel3;

public class CoinbaseProProductBook {
    private final Long sequence;
    private final CoinbaseProProductBookEntry[] bids;
    private final CoinbaseProProductBookEntry[] asks;

    public CoinbaseProProductBook(@JsonProperty(value="sequence") Long sequence, @JsonProperty(value="bids") Object[][] bids, @JsonProperty(value="asks") Object[][] asks) {
        int i;
        this.sequence = sequence;
        if (bids != null && bids.length > 0) {
            this.bids = new CoinbaseProProductBookEntry[bids.length];
            for (i = 0; i < bids.length; ++i) {
                this.bids[i] = CoinbaseProProductBook.convertToBookEntry(bids[i]);
            }
        } else {
            this.bids = null;
        }
        if (asks != null && asks.length > 0) {
            this.asks = new CoinbaseProProductBookEntry[asks.length];
            for (i = 0; i < asks.length; ++i) {
                this.asks[i] = CoinbaseProProductBook.convertToBookEntry(asks[i]);
            }
        } else {
            this.asks = null;
        }
    }

    private static CoinbaseProProductBookEntry convertToBookEntry(Object[] dataObject) {
        if (dataObject != null && dataObject.length == 3) {
            BigDecimal price = new BigDecimal((String)dataObject[0]);
            BigDecimal volume = new BigDecimal((String)dataObject[1]);
            if (dataObject[2] instanceof String) {
                return new CoinbaseProProductBookEntryLevel3(price, volume, (String)dataObject[2]);
            }
            int numberOfOrders = (Integer)dataObject[2];
            return new CoinbaseProProductBookEntryLevel1or2(price, volume, numberOfOrders);
        }
        return null;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public CoinbaseProProductBookEntry[] getBids() {
        return this.bids;
    }

    public CoinbaseProProductBookEntry[] getAsks() {
        return this.asks;
    }

    public CoinbaseProProductBookEntry getBestBid() {
        if (this.getBids() != null && this.getBids().length > 0) {
            return this.getBids()[0];
        }
        return null;
    }

    public CoinbaseProProductBookEntry getBestAsk() {
        if (this.getAsks() != null && this.getAsks().length > 0) {
            return this.getAsks()[0];
        }
        return null;
    }

    public String toString() {
        return "CoinbaseProProductBook [sequence=" + this.sequence + ", bids=" + Arrays.toString(this.bids) + ", asks=" + Arrays.toString(this.asks) + "]";
    }
}

