/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import jakarta.ws.rs.HeaderParam;
import java.math.BigInteger;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BitstampDigestV2
extends BaseParamsDigest {
    private final String apiKey;
    private final String baseUrlHost = "www.bitstamp.net";

    private BitstampDigestV2(String secretKeyBase64, String apiKey) {
        super(secretKeyBase64, "HmacSHA256");
        this.apiKey = "BITSTAMP " + apiKey;
    }

    public static BitstampDigestV2 createInstance(String secretKeyBase64, String apiKey) {
        return secretKeyBase64 == null ? null : new BitstampDigestV2(secretKeyBase64, apiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        Mac mac256 = this.getMac();
        String okPath = "/" + restInvocation.getPath();
        String contentType = restInvocation.getReqContentType();
        mac256.update(this.apiKey.getBytes());
        mac256.update(restInvocation.getHttpMethod().getBytes());
        mac256.update("www.bitstamp.net".getBytes());
        mac256.update(okPath.getBytes());
        mac256.update(restInvocation.getQueryString().getBytes());
        if (contentType != null) {
            mac256.update(contentType.getBytes());
        }
        mac256.update(restInvocation.getParamValue(HeaderParam.class, "X-Auth-Nonce").toString().getBytes());
        mac256.update(restInvocation.getParamValue(HeaderParam.class, "X-Auth-Timestamp").toString().getBytes());
        mac256.update(restInvocation.getParamValue(HeaderParam.class, "X-Auth-Version").toString().getBytes());
        mac256.update(restInvocation.getRequestBody().getBytes());
        return String.format("%064x", new BigInteger(1, mac256.doFinal())).toUpperCase();
    }
}

