/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.service;

import jakarta.ws.rs.FormParam;
import java.math.BigInteger;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BitstampDigest
extends BaseParamsDigest {
    private final String clientId;
    private final String apiKey;

    private BitstampDigest(String secretKeyBase64, String clientId, String apiKey) {
        super(secretKeyBase64, "HmacSHA256");
        this.clientId = clientId;
        this.apiKey = apiKey;
    }

    public static BitstampDigest createInstance(String secretKeyBase64, String clientId, String apiKey) {
        return secretKeyBase64 == null ? null : new BitstampDigest(secretKeyBase64, clientId, apiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        Mac mac256 = this.getMac();
        mac256.update(restInvocation.getParamValue(FormParam.class, "nonce").toString().getBytes());
        mac256.update(this.clientId.getBytes());
        mac256.update(this.apiKey.getBytes());
        return String.format("%064x", new BigInteger(1, mac256.doFinal())).toUpperCase();
    }
}

