/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.trade;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.bitstamp.BitstampUtils;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;

public class BitstampOrderTransaction {
    private final Date datetime;
    private final long tid;
    private final BitstampUserTransaction.TransactionType type;
    private final Map<String, BigDecimal> amounts = new HashMap<String, BigDecimal>();
    private final BigDecimal price;
    private final BigDecimal fee;

    public BitstampOrderTransaction(@JsonProperty(value="datetime") String datetime, @JsonProperty(value="tid") long tid, @JsonProperty(value="type") BitstampUserTransaction.TransactionType type, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="fee") BigDecimal fee) {
        this.datetime = BitstampUtils.parseDate(datetime);
        this.tid = tid;
        this.type = type;
        this.price = price;
        this.fee = fee;
    }

    @JsonAnySetter
    public void setDynamicProperty(String name, Object value) {
        if (value != null) {
            this.amounts.put(name, new BigDecimal(value.toString()));
        }
    }

    public Date getDatetime() {
        return this.datetime;
    }

    public long getTid() {
        return this.tid;
    }

    public BitstampUserTransaction.TransactionType getType() {
        return this.type;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigDecimal getAmount(String token) {
        return this.amounts.get(token);
    }

    public Map<String, BigDecimal> getAmounts() {
        return this.amounts;
    }
}

