/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;

@JsonDeserialize(builder=BitstampTickerBuilder.class)
public final class BitstampTicker {
    @JsonProperty(value="pair")
    private final String pair;
    @JsonProperty(value="open")
    private final BigDecimal open;
    @JsonProperty(value="last")
    private final BigDecimal last;
    @JsonProperty(value="high")
    private final BigDecimal high;
    @JsonProperty(value="low")
    private final BigDecimal low;
    @JsonProperty(value="vwap")
    private final BigDecimal vwap;
    @JsonProperty(value="volume")
    private final BigDecimal volume;
    @JsonProperty(value="bid")
    private final BigDecimal bid;
    @JsonProperty(value="ask")
    private final BigDecimal ask;
    @JsonProperty(value="timestamp")
    private final long timestamp;

    BitstampTicker(String pair, BigDecimal open, BigDecimal last, BigDecimal high, BigDecimal low, BigDecimal vwap, BigDecimal volume, BigDecimal bid, BigDecimal ask, long timestamp) {
        this.pair = pair;
        this.open = open;
        this.last = last;
        this.high = high;
        this.low = low;
        this.vwap = vwap;
        this.volume = volume;
        this.bid = bid;
        this.ask = ask;
        this.timestamp = timestamp;
    }

    public static BitstampTickerBuilder builder() {
        return new BitstampTickerBuilder();
    }

    public String getPair() {
        return this.pair;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVwap() {
        return this.vwap;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitstampTicker)) {
            return false;
        }
        BitstampTicker other = (BitstampTicker)o;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$pair = this.getPair();
        String other$pair = other.getPair();
        if (this$pair == null ? other$pair != null : !this$pair.equals(other$pair)) {
            return false;
        }
        BigDecimal this$open = this.getOpen();
        BigDecimal other$open = other.getOpen();
        if (this$open == null ? other$open != null : !((Object)this$open).equals(other$open)) {
            return false;
        }
        BigDecimal this$last = this.getLast();
        BigDecimal other$last = other.getLast();
        if (this$last == null ? other$last != null : !((Object)this$last).equals(other$last)) {
            return false;
        }
        BigDecimal this$high = this.getHigh();
        BigDecimal other$high = other.getHigh();
        if (this$high == null ? other$high != null : !((Object)this$high).equals(other$high)) {
            return false;
        }
        BigDecimal this$low = this.getLow();
        BigDecimal other$low = other.getLow();
        if (this$low == null ? other$low != null : !((Object)this$low).equals(other$low)) {
            return false;
        }
        BigDecimal this$vwap = this.getVwap();
        BigDecimal other$vwap = other.getVwap();
        if (this$vwap == null ? other$vwap != null : !((Object)this$vwap).equals(other$vwap)) {
            return false;
        }
        BigDecimal this$volume = this.getVolume();
        BigDecimal other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
            return false;
        }
        BigDecimal this$bid = this.getBid();
        BigDecimal other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
            return false;
        }
        BigDecimal this$ask = this.getAsk();
        BigDecimal other$ask = other.getAsk();
        return !(this$ask == null ? other$ask != null : !((Object)this$ask).equals(other$ask));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $pair = this.getPair();
        result = result * 59 + ($pair == null ? 43 : $pair.hashCode());
        BigDecimal $open = this.getOpen();
        result = result * 59 + ($open == null ? 43 : ((Object)$open).hashCode());
        BigDecimal $last = this.getLast();
        result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
        BigDecimal $high = this.getHigh();
        result = result * 59 + ($high == null ? 43 : ((Object)$high).hashCode());
        BigDecimal $low = this.getLow();
        result = result * 59 + ($low == null ? 43 : ((Object)$low).hashCode());
        BigDecimal $vwap = this.getVwap();
        result = result * 59 + ($vwap == null ? 43 : ((Object)$vwap).hashCode());
        BigDecimal $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
        BigDecimal $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
        BigDecimal $ask = this.getAsk();
        result = result * 59 + ($ask == null ? 43 : ((Object)$ask).hashCode());
        return result;
    }

    public String toString() {
        return "BitstampTicker(pair=" + this.getPair() + ", open=" + this.getOpen() + ", last=" + this.getLast() + ", high=" + this.getHigh() + ", low=" + this.getLow() + ", vwap=" + this.getVwap() + ", volume=" + this.getVolume() + ", bid=" + this.getBid() + ", ask=" + this.getAsk() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class BitstampTickerBuilder {
        private String pair;
        private BigDecimal open;
        private BigDecimal last;
        private BigDecimal high;
        private BigDecimal low;
        private BigDecimal vwap;
        private BigDecimal volume;
        private BigDecimal bid;
        private BigDecimal ask;
        private long timestamp;

        BitstampTickerBuilder() {
        }

        @JsonProperty(value="pair")
        public BitstampTickerBuilder pair(String pair) {
            this.pair = pair;
            return this;
        }

        @JsonProperty(value="open")
        public BitstampTickerBuilder open(BigDecimal open) {
            this.open = open;
            return this;
        }

        @JsonProperty(value="last")
        public BitstampTickerBuilder last(BigDecimal last) {
            this.last = last;
            return this;
        }

        @JsonProperty(value="high")
        public BitstampTickerBuilder high(BigDecimal high) {
            this.high = high;
            return this;
        }

        @JsonProperty(value="low")
        public BitstampTickerBuilder low(BigDecimal low) {
            this.low = low;
            return this;
        }

        @JsonProperty(value="vwap")
        public BitstampTickerBuilder vwap(BigDecimal vwap) {
            this.vwap = vwap;
            return this;
        }

        @JsonProperty(value="volume")
        public BitstampTickerBuilder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        @JsonProperty(value="bid")
        public BitstampTickerBuilder bid(BigDecimal bid) {
            this.bid = bid;
            return this;
        }

        @JsonProperty(value="ask")
        public BitstampTickerBuilder ask(BigDecimal ask) {
            this.ask = ask;
            return this;
        }

        @JsonProperty(value="timestamp")
        public BitstampTickerBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BitstampTicker build() {
            return new BitstampTicker(this.pair, this.open, this.last, this.high, this.low, this.vwap, this.volume, this.bid, this.ask, this.timestamp);
        }

        public String toString() {
            return "BitstampTicker.BitstampTickerBuilder(pair=" + this.pair + ", open=" + this.open + ", last=" + this.last + ", high=" + this.high + ", low=" + this.low + ", vwap=" + this.vwap + ", volume=" + this.volume + ", bid=" + this.bid + ", ask=" + this.ask + ", timestamp=" + this.timestamp + ")";
        }
    }
}

