/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp.dto.account;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class BitstampBalance {
    private final BigDecimal fee;
    private final String error;
    private final Map<String, Balance> balances = new HashMap<String, Balance>();
    private final Map<String, BigDecimal> fees = new HashMap<String, BigDecimal>();

    public BitstampBalance(@JsonProperty(value="fee") BigDecimal fee, @JsonProperty(value="error") String error) {
        this.fee = fee;
        this.error = error;
    }

    @JsonAnySetter
    public void setDynamicProperty(String name, BigDecimal value) {
        String post;
        int idx = name.indexOf(95);
        if (idx < 0) {
            // empty if block
        }
        String pre = name.substring(0, idx);
        switch (post = name.substring(idx + 1)) {
            case "fee": {
                this.fees.put(pre, value);
                break;
            }
            case "balance": {
                this.getBalance(pre).balance = value;
                break;
            }
            case "available": {
                this.getBalance(pre).available = value;
                break;
            }
            case "reserved": {
                this.getBalance(pre).reserved = value;
                break;
            }
        }
    }

    private Balance getBalance(String currency) {
        Balance b = this.balances.get(currency);
        if (b == null) {
            b = new Balance(currency);
            this.balances.put(currency, b);
        }
        return b;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public BigDecimal getFee(String pair) {
        return this.fees.get(pair);
    }

    public String getError() {
        return this.error;
    }

    public Collection<Balance> getBalances() {
        return this.balances.values();
    }

    public static final class Balance {
        private final String currency;
        private BigDecimal balance;
        private BigDecimal reserved;
        private BigDecimal available;

        public Balance(String currency) {
            this.currency = currency;
        }

        public String getCurrency() {
            return this.currency;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public BigDecimal getReserved() {
            return this.reserved;
        }

        public BigDecimal getAvailable() {
            return this.available;
        }
    }
}

