/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitstamp;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.bitstamp.BitstampV2;
import org.knowm.xchange.bitstamp.dto.BitstampException;
import org.knowm.xchange.bitstamp.dto.BitstampTransferBalanceResponse;
import org.knowm.xchange.bitstamp.dto.account.BitstampBalance;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampRippleDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampWithdrawal;
import org.knowm.xchange.bitstamp.dto.account.DepositTransaction;
import org.knowm.xchange.bitstamp.dto.account.WithdrawalRequest;
import org.knowm.xchange.bitstamp.dto.trade.BitstampCancelAllOrdersResponse;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrder;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrderCancelResponse;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrderStatusResponse;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="api/v2")
@Produces(value={"application/json"})
public interface BitstampAuthenticatedV2 {
    @POST
    @Path(value="open_orders/all/")
    public BitstampOrder[] getOpenOrders(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="open_orders/{pair}/")
    public BitstampOrder[] getOpenOrders(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @PathParam(value="pair") BitstampV2.Pair var6) throws BitstampException, IOException;

    @POST
    @Path(value="{side}/market/{pair}/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampOrder placeMarketOrder(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @PathParam(value="side") Side var6, @PathParam(value="pair") BitstampV2.Pair var7, @FormParam(value="amount") BigDecimal var8) throws BitstampException, IOException;

    @POST
    @Path(value="{side}/{pair}/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampOrder placeOrder(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @PathParam(value="side") Side var6, @PathParam(value="pair") BitstampV2.Pair var7, @FormParam(value="amount") BigDecimal var8, @FormParam(value="price") BigDecimal var9) throws BitstampException, IOException;

    @POST
    @Path(value="cancel_order/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampOrderCancelResponse cancelOrder(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="id") long var6) throws BitstampException, IOException;

    @POST
    @Path(value="cancel_all_orders/")
    public BitstampCancelAllOrdersResponse cancelAllOrders(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="order_status/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampOrderStatusResponse getOrderStatus(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="id") long var6) throws BitstampException, IOException;

    @POST
    @Path(value="balance/")
    public BitstampBalance getBalance(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="user_transactions/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampUserTransaction[] getUserTransactions(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="limit") Long var6, @FormParam(value="offset") Long var7, @FormParam(value="sort") String var8, @FormParam(value="since_timestamp") Long var9, @FormParam(value="since_id") String var10) throws BitstampException, IOException;

    @POST
    @Path(value="user_transactions/{pair}/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampUserTransaction[] getUserTransactions(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @PathParam(value="pair") BitstampV2.Pair var6, @FormParam(value="limit") Long var7, @FormParam(value="offset") Long var8, @FormParam(value="sort") String var9, @FormParam(value="since_timestamp") Long var10, @FormParam(value="since_id") String var11) throws BitstampException, IOException;

    @POST
    @Path(value="btc_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawBTC(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="xrp_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawXRP(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7, @FormParam(value="destination_tag") Long var8) throws BitstampException, IOException;

    @POST
    @Path(value="ltc_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawLTC(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="bch_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawBCH(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="eth_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawETH(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="xlm_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawXLM(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7, @FormParam(value="memo_id") Long var8) throws BitstampException, IOException;

    @POST
    @Path(value="pax_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawPAX(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="link_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawLINK(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="omg_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawOMG(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="usdc_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawUSDC(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="aave_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawAAVE(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="bat_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawBAT(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="uma_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawUMA(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="dai_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawDAI(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="knc_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawKNC(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="mkr_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawMKR(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="zrx_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawZRX(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="gusd_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawGUSD(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="algo_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawALGO(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="audio_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawAUDIO(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="crv_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawCRV(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="snx_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawSNX(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="uni_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawUNI(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="yfi_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawYFI(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="COMP_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawCOMP(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="grt_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawGRT(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="usdt_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawUSDT(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="eurt_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawEURT(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="matic_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawMATIC(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="sushi_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawSUSHI(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="chz_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawCHZ(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="enj_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawENJ(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="alpha_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawALPHA(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="ftt_withdrawal/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal withdrawFTT(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws BitstampException, IOException;

    @POST
    @Path(value="transfer-to-main/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampTransferBalanceResponse transferSubAccountBalanceToMain(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="currency") String var7, @FormParam(value="subAccount") String var8) throws BitstampException, IOException;

    @POST
    @Path(value="withdrawal-requests/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public WithdrawalRequest[] getWithdrawalRequests(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="timedelta") Long var6) throws BitstampException, IOException;

    @POST
    @Path(value="withdrawal/open/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public BitstampWithdrawal bankWithdrawal(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="account_currency") AccountCurrency var7, @FormParam(value="name") String var8, @FormParam(value="iban") String var9, @FormParam(value="bic") String var10, @FormParam(value="address") String var11, @FormParam(value="postal_code") String var12, @FormParam(value="city") String var13, @FormParam(value="country") String var14, @FormParam(value="type") BankWithdrawalType var15, @FormParam(value="bank_name") String var16, @FormParam(value="bank_address") String var17, @FormParam(value="bank_postal_code") String var18, @FormParam(value="bank_city") String var19, @FormParam(value="bank_country") String var20, @FormParam(value="currency") BankCurrency var21, @FormParam(value="comment") String var22) throws BitstampException, IOException;

    @POST
    @Path(value="btc_address/")
    public BitstampDepositAddress getBitcoinDepositAddress(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="ltc_address/")
    public BitstampDepositAddress getLitecoinDepositAddress(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="bch_address/")
    public BitstampDepositAddress getBitcoinCashDepositAddress(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="eth_address/")
    public BitstampDepositAddress getEthereumDepositAddress(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="xrp_address/")
    public BitstampRippleDepositAddress getXRPDepositAddress(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="ripple_address/")
    public BitstampRippleDepositAddress getRippleIOUDepositAddress(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    @POST
    @Path(value="ripple_withdrawal/")
    public boolean withdrawToRipple(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7, @FormParam(value="currency") String var8) throws BitstampException, IOException;

    @POST
    @Path(value="btc_unconfirmed/")
    public DepositTransaction[] getUnconfirmedBTCDeposits(@HeaderParam(value="X-Auth") String var1, @HeaderParam(value="X-Auth-Signature") ParamsDigest var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<String> var3, @HeaderParam(value="X-Auth-Timestamp") SynchronizedValueFactory<String> var4, @HeaderParam(value="X-Auth-Version") String var5) throws BitstampException, IOException;

    public static enum BankCurrency {
        AED,
        AFN,
        ALL,
        AMD,
        ANG,
        AOA,
        ARS,
        AUD,
        AWG,
        AZN,
        BAM,
        BBD,
        BDT,
        BGN,
        BHD,
        BIF,
        BMD,
        BND,
        BOB,
        BOV,
        BRL,
        BSD,
        BTN,
        BWP,
        BYN,
        BZD,
        CAD,
        CDF,
        CHE,
        CHF,
        CHW,
        CLF,
        CLP,
        CNY,
        COP,
        COU,
        CRC,
        CUC,
        CUP,
        CVE,
        CZK,
        DJF,
        DKK,
        DOP,
        DZD,
        EGP,
        ERN,
        ETB,
        EUR,
        FJD,
        FKP,
        GBP,
        GEL,
        GHS,
        GIP,
        GMD,
        GNF,
        GTQ,
        GYD,
        HKD,
        HNL,
        HRK,
        HTG,
        HUF,
        IDR,
        ILS,
        INR,
        IQD,
        IRR,
        ISK,
        JMD,
        JOD,
        JPY,
        KES,
        KGS,
        KHR,
        KMF,
        KPW,
        KRW,
        KWD,
        KYD,
        KZT,
        LAK,
        LBP,
        LKR,
        LRD,
        LSL,
        LYD,
        MAD,
        MDL,
        MGA,
        MKD,
        MMK,
        MNT,
        MOP,
        MUR,
        MVR,
        MWK,
        MXN,
        MXV,
        MYR,
        MZN,
        NAD,
        NGN,
        NIO,
        NOK,
        NPR,
        NZD,
        OMR,
        PAB,
        PEN,
        PGK,
        PHP,
        PKR,
        PLN,
        PYG,
        QAR,
        RON,
        RSD,
        RUB,
        RWF,
        SAR,
        SBD,
        SCR,
        SDG,
        SEK,
        SGD,
        SHP,
        SLL,
        SOS,
        SRD,
        SSP,
        SVC,
        SYP,
        SZL,
        THB,
        TJS,
        TMT,
        TND,
        TOP,
        TRY,
        TTD,
        TWD,
        TZS,
        UAH,
        UGX,
        USD,
        USN,
        UYI,
        UYU,
        UZS,
        VEF,
        VND,
        VUV,
        WST,
        XAF,
        XAG,
        XAU,
        XBA,
        XBB,
        XBC,
        XBD,
        XCD,
        XDR,
        XOF,
        XPD,
        XPF,
        XPT,
        XSU,
        XTS,
        XUA,
        XXX,
        YER,
        ZAR,
        ZMW,
        ZWL;

    }

    public static enum Country {
        Afghanistan("AF"),
        \u00c5land_Islands("AX"),
        Albania("AL"),
        Algeria("DZ"),
        American_Samoa("AS"),
        Andorra("AD"),
        Angola("AO"),
        Anguilla("AI"),
        Antarctica("AQ"),
        Antigua_and_Barbuda("AG"),
        Argentina("AR"),
        Armenia("AM"),
        Aruba("AW"),
        Australia("AU"),
        Austria("AT"),
        Azerbaijan("AZ"),
        Bahamas("BS"),
        Bahrain("BH"),
        Bangladesh("BD"),
        Barbados("BB"),
        Belarus("BY"),
        Belgium("BE"),
        Belize("BZ"),
        Benin("BJ"),
        Bermuda("BM"),
        Bhutan("BT"),
        Bolivia("BO"),
        Bosnia_and_Herzegovina("BA"),
        Botswana("BW"),
        Bouvet_Island("BV"),
        Brazil("BR"),
        Brunei_Darussalam("BN"),
        Bulgaria("BG"),
        Burkina_Faso("BF"),
        Burundi("BI"),
        Cabo_Verde("CV"),
        Cambodia("KH"),
        Cameroon("CM"),
        Canada("CA"),
        Cayman_Islands("KY"),
        Central_African_Republic("CF"),
        Chad("TD"),
        Chile("CL"),
        China("CN"),
        Christmas_Island("CX"),
        Cocos_Islands("CC"),
        Colombia("CO"),
        Comoros("KM"),
        Cook_Islands("CK"),
        Costa_Rica("CR"),
        Cote_dIvoire("CI"),
        Croatia("HR"),
        Cuba("CU"),
        Curacao("CW"),
        Cyprus("CY"),
        Czechia("CZ"),
        Denmark("DK"),
        Djibouti("DJ"),
        Dominica("DM"),
        Dominican_Republic("DO"),
        Ecuador("EC"),
        Egypt("EG"),
        El_Salvador("SV"),
        Equatorial_Guinea("GQ"),
        Eritrea("ER"),
        Estonia("EE"),
        Ethiopia("ET"),
        Falkland_Islands("FK"),
        Faroe_Islands("FO"),
        Fiji("FJ"),
        Finland("FI"),
        France("FR"),
        French_Guiana("GF"),
        French_Polynesia("PF"),
        French_Southern_Territories("TF"),
        Gabon("GA"),
        Gambia("GM"),
        Georgia("GE"),
        Germany("DE"),
        Ghana("GH"),
        Gibraltar("GI"),
        Greece("GR"),
        Greenland("GL"),
        Grenada("GD"),
        Guadeloupe("GP"),
        Guam("GU"),
        Guatemala("GT"),
        Guernsey("GG"),
        Guinea("GN"),
        Guinea_Bissau("GW"),
        Guyana("GY"),
        Haiti("HT"),
        Holy_See("VA"),
        Honduras("HN"),
        Hong_Kong("HK"),
        Hungary("HU"),
        Iceland("IS"),
        India("IN"),
        Indonesia("ID"),
        Iran("IR"),
        Iraq("IQ"),
        Ireland("IE"),
        Isle_of_Man("IM"),
        Israel("IL"),
        Italy("IT"),
        Jamaica("JM"),
        Japan("JP"),
        Jersey("JE"),
        Jordan("JO"),
        Kazakhstan("KZ"),
        Kenya("KE"),
        Kiribati("KI"),
        Korea_South("KP"),
        Kuwait("KW"),
        Kyrgyzstan("KG"),
        Lao("LA"),
        Latvia("LV"),
        Lebanon("LB"),
        Lesotho("LS"),
        Liberia("LR"),
        Libya("LY"),
        Liechtenstein("LI"),
        Lithuania("LT"),
        Luxembourg("LU"),
        Macao("MO"),
        Macedonia("MK"),
        Malaysia("MY"),
        Maldives("MV"),
        Mali("ML"),
        Malta("MT"),
        Marshall_Islands("MH"),
        Martinique("MQ"),
        Mauritania("MR"),
        Mauritius("MU"),
        Mayotte("YT"),
        Mexico("MX"),
        Micronesia("FM"),
        Moldova("MD"),
        Monaco("MC"),
        Mongolia("MN"),
        Montenegro("ME"),
        Montserrat("MS"),
        Morocco("MA"),
        Mozambique("MZ"),
        Myanmar("MM"),
        Namibia("NA"),
        Nauru("NR"),
        Nepal("NP"),
        Netherlands("NL"),
        New_Caledonia("NC"),
        New_Zealand("NZ"),
        Nicaragua("NI"),
        Niger("NE"),
        Nigeria("NG"),
        Niue("NU"),
        Norfolk_Island("NF"),
        Northern_Mariana_Islands("MP"),
        Norway("NO"),
        Oman("OM"),
        Pakistan("PK"),
        Palau("PW"),
        Palestine("PS"),
        Panama("PA"),
        Papua_New_Guinea("PG"),
        Paraguay("PY"),
        Peru("PE"),
        Philippines("PH"),
        Pitcairn("PN"),
        Poland("PL"),
        Portugal("PT"),
        Puerto_Rico("PR"),
        Qatar("QA"),
        Reunion("RE"),
        Romania("RO"),
        Russian_Federation("RU"),
        Rwanda("RW"),
        Saint_Lucia("LC"),
        Samoa("WS"),
        San_Marino("SM"),
        Saudi_Arabia("SA"),
        Senegal("SN"),
        Serbia("RS"),
        Seychelles("SC"),
        Sierra_Leone("SL"),
        Singapore("SG"),
        Slovakia("SK"),
        Slovenia("SI"),
        Solomon_Islands("SB"),
        Somalia("SO"),
        South_Africa("ZA"),
        South_Sudan("SS"),
        Spain("ES"),
        Sri_Lanka("LK"),
        Sudan("SD"),
        Suriname("SR"),
        Swaziland("SZ"),
        Sweden("SE"),
        Switzerland("CH"),
        Syria("SY"),
        Taiwan("TW"),
        Tajikistan("TJ"),
        Tanzania("TZ"),
        Thailand("TH"),
        Timor_Leste("TL"),
        Togo("TG"),
        Tokelau("TK"),
        Tonga("TO"),
        Trinidad_and_Tobago("TT"),
        Tunisia("TN"),
        Turkey("TR"),
        Turkmenistan("TM"),
        Tuvalu("TV"),
        Uganda("UG"),
        Ukraine("UA"),
        United_Arab_Emirates("AE"),
        England("GB"),
        USA("US"),
        Uruguay("UY"),
        Uzbekistan("UZ"),
        Vanuatu("VU"),
        Venezuela("VE"),
        Viet_Nam("VN"),
        Virgin_Islands_British("VG"),
        Virgin_Islands_USA("VI"),
        Wallis_and_Futuna("WF"),
        Western_Sahara("EH"),
        Yemen("YE"),
        Zambia("ZM"),
        Zimbabwe("ZW");

        public String alpha2;

        private Country(String alpha2) {
            this.alpha2 = alpha2;
        }
    }

    public static enum BankWithdrawalType {
        sepa,
        international;

    }

    public static enum AccountCurrency {
        USD,
        EUR;

    }

    public static enum Side {
        buy,
        sell;

    }
}

