/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitso.BitsoAuthenticated;
import org.knowm.xchange.bitso.dto.trade.BitsoOrder;
import org.knowm.xchange.bitso.dto.trade.BitsoUserTransaction;
import org.knowm.xchange.bitso.service.BitsoBaseService;
import org.knowm.xchange.bitso.service.BitsoDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitsoTradeServiceRaw
extends BitsoBaseService {
    private final BitsoAuthenticated bitsoAuthenticated;
    private final BitsoDigest signatureCreator;

    public BitsoTradeServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitsoAuthenticated = (BitsoAuthenticated)ExchangeRestProxyBuilder.forInterface(BitsoAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.signatureCreator = BitsoDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), exchange.getExchangeSpecification().getApiKey());
    }

    public BitsoOrder[] getBitsoOpenOrders() throws IOException {
        return this.bitsoAuthenticated.getOpenOrders(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
    }

    public BitsoOrder sellBitsoOrder(BigDecimal originalAmount, BigDecimal price) throws IOException {
        return this.bitsoAuthenticated.sell(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), originalAmount, price);
    }

    public BitsoOrder buyBitoOrder(BigDecimal originalAmount, BigDecimal price) throws IOException {
        return this.bitsoAuthenticated.buy(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), originalAmount, price);
    }

    public boolean cancelBitsoOrder(String orderId) throws IOException {
        return this.bitsoAuthenticated.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), orderId);
    }

    public BitsoUserTransaction[] getBitsoUserTransactions(Long numberOfTransactions) throws IOException {
        return this.bitsoAuthenticated.getUserTransactions(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), numberOfTransactions);
    }

    public BitsoUserTransaction[] getBitsoUserTransactions(Long numberOfTransactions, Long offset, String sort) throws IOException {
        return this.bitsoAuthenticated.getUserTransactions(this.exchange.getExchangeSpecification().getApiKey(), (ParamsDigest)this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), numberOfTransactions, offset, sort);
    }
}

