/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitso.BitsoAdapters;
import org.knowm.xchange.bitso.dto.BitsoException;
import org.knowm.xchange.bitso.dto.trade.BitsoOrder;
import org.knowm.xchange.bitso.service.BitsoTradeServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class BitsoTradeService
extends BitsoTradeServiceRaw
implements TradeService {
    public BitsoTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException, BitsoException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        BitsoOrder[] openOrders = this.getBitsoOpenOrders();
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BitsoOrder bitsoOrder : openOrders) {
            Order.OrderType orderType = bitsoOrder.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK;
            String id = bitsoOrder.getId();
            BigDecimal price = bitsoOrder.getPrice();
            limitOrders.add(new LimitOrder(orderType, bitsoOrder.getAmount(), (Instrument)new CurrencyPair(Currency.BTC, Currency.MXN), id, bitsoOrder.getTime(), price));
        }
        return new OpenOrders(limitOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException, BitsoException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException, BitsoException {
        BitsoOrder bitsoOrder = limitOrder.getType() == Order.OrderType.BID ? this.buyBitoOrder(limitOrder.getOriginalAmount(), limitOrder.getLimitPrice()) : this.sellBitsoOrder(limitOrder.getOriginalAmount(), limitOrder.getLimitPrice());
        if (bitsoOrder.getErrorMessage() != null) {
            throw new ExchangeException(bitsoOrder.getErrorMessage());
        }
        return bitsoOrder.getId();
    }

    public boolean cancelOrder(String orderId) throws IOException, BitsoException {
        return this.cancelBitsoOrder(orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        return BitsoAdapters.adaptTradeHistory(this.getBitsoUserTransactions((long)((TradeHistoryParamPaging)params).getPageLength()));
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new DefaultTradeHistoryParamPaging(Integer.valueOf(1000));
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }
}

