/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitso.Bitso;
import org.knowm.xchange.bitso.dto.marketdata.BitsoOrderBook;
import org.knowm.xchange.bitso.dto.marketdata.BitsoTicker;
import org.knowm.xchange.bitso.dto.marketdata.BitsoTransaction;
import org.knowm.xchange.bitso.service.BitsoBaseService;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;

public class BitsoMarketDataServiceRaw
extends BitsoBaseService {
    private final Bitso bitso;

    public BitsoMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitso = (Bitso)ExchangeRestProxyBuilder.forInterface(Bitso.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    public BitsoOrderBook getBitsoOrderBook(CurrencyPair pair) throws IOException {
        return this.bitso.getOrderBook();
    }

    public BitsoTransaction[] getBitsoTransactions(Object ... args) throws IOException {
        BitsoTransaction[] transactions = null;
        if (args.length == 0) {
            transactions = this.bitso.getTransactions();
        } else if (args.length == 1) {
            BitsoTime bitsoTime = BitsoTime.valueOf(((String)args[0]).toUpperCase());
            transactions = this.bitso.getTransactions(bitsoTime.toString().toLowerCase());
        } else {
            throw new ExchangeException("Invalid argument length. Must be 0, or 1.");
        }
        return transactions;
    }

    public BitsoTicker getBitsoTicker(CurrencyPair pair) throws IOException {
        return this.bitso.getTicker(pair.base + "_" + pair.counter);
    }

    public static enum BitsoTime {
        HOUR,
        MINUTE;

    }
}

