/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.service;

import jakarta.ws.rs.FormParam;
import java.math.BigInteger;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BitsoDigest
extends BaseParamsDigest {
    private final String clientId;
    private final String apiKey;

    private BitsoDigest(String secretKeyHex, String clientId, String apiKey) {
        super(secretKeyHex, "HmacSHA256");
        this.clientId = clientId;
        this.apiKey = apiKey;
    }

    public static BitsoDigest createInstance(String secretKey, String userName, String apiKey) {
        return secretKey == null ? null : new BitsoDigest(secretKey, userName, apiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        Mac mac256 = this.getMac();
        mac256.update(restInvocation.getParamValue(FormParam.class, "nonce").toString().getBytes());
        mac256.update(this.clientId.getBytes());
        mac256.update(this.apiKey.getBytes());
        return String.format("%064x", new BigInteger(1, mac256.doFinal())).toUpperCase();
    }
}

