/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitso.BitsoAuthenticated;
import org.knowm.xchange.bitso.dto.account.BitsoBalance;
import org.knowm.xchange.bitso.dto.account.BitsoDepositAddress;
import org.knowm.xchange.bitso.service.BitsoBaseService;
import org.knowm.xchange.bitso.service.BitsoDigest;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitsoAccountServiceRaw
extends BitsoBaseService {
    private final BitsoDigest signatureCreator;
    private final BitsoAuthenticated bitsoAuthenticated;

    protected BitsoAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.bitsoAuthenticated = (BitsoAuthenticated)ExchangeRestProxyBuilder.forInterface(BitsoAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.signatureCreator = BitsoDigest.createInstance(exchange.getExchangeSpecification().getSecretKey(), exchange.getExchangeSpecification().getUserName(), exchange.getExchangeSpecification().getApiKey());
    }

    public BitsoBalance getBitsoBalance() throws IOException {
        BitsoBalance bitsoBalance = this.bitsoAuthenticated.getBalance(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (bitsoBalance.getError() != null) {
            throw new ExchangeException("Error getting balance. " + bitsoBalance.getError());
        }
        return bitsoBalance;
    }

    public String withdrawBitsoFunds(BigDecimal amount, String address) throws IOException {
        String response = this.bitsoAuthenticated.withdrawBitcoin(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, address);
        if (!"ok".equals(response)) {
            throw new ExchangeException("Withdrawing funds from Bitso failed: " + response);
        }
        return response;
    }

    public BitsoDepositAddress getBitsoBitcoinDepositAddress() throws IOException {
        BitsoDepositAddress response = this.bitsoAuthenticated.getBitcoinDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (response.getError() != null) {
            throw new ExchangeException("Requesting Bitcoin deposit address failed: " + response.getError());
        }
        return response;
    }

    public boolean withdrawToRipple(BigDecimal amount, Currency currency, String rippleAddress) throws IOException {
        String result = this.bitsoAuthenticated.withdrawToRipple(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), amount, currency.getCurrencyCode(), rippleAddress);
        return "ok".equals(result);
    }
}

