/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.dto.trade;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import org.knowm.xchange.bitso.util.BitsoTransactionTypeDeserializer;

public final class BitsoUserTransaction {
    private final String datetime;
    private final long id;
    private final String order_id;
    private final TransactionType type;
    private final BigDecimal mxn;
    private final BigDecimal btc;
    private final BigDecimal rate;
    private final BigDecimal fee;

    public BitsoUserTransaction(@JsonProperty(value="datetime") String datetime, @JsonProperty(value="id") long id, @JsonProperty(value="order_id") String order_id, @JsonProperty(value="type") @JsonDeserialize(using=BitsoTransactionTypeDeserializer.class) TransactionType type, @JsonProperty(value="mxn") BigDecimal mxn, @JsonProperty(value="btc") BigDecimal btc, @JsonProperty(value="rate") BigDecimal rate, @JsonProperty(value="fee") BigDecimal fee) {
        this.datetime = datetime;
        this.id = id;
        this.order_id = order_id;
        this.type = type;
        this.mxn = mxn;
        this.btc = btc;
        this.rate = rate;
        this.fee = fee;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public long getId() {
        return this.id;
    }

    public String getOrderId() {
        return this.order_id;
    }

    public TransactionType getType() {
        return this.type;
    }

    public boolean isDeposit() {
        return this.type == TransactionType.deposit;
    }

    public boolean isWithdrawal() {
        return this.type == TransactionType.withdrawal;
    }

    public boolean isMarketTrade() {
        return this.type == TransactionType.trade;
    }

    public BigDecimal getMxn() {
        return this.mxn;
    }

    public BigDecimal getBtc() {
        return this.btc;
    }

    public BigDecimal getPrice() {
        return this.rate;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public String toString() {
        return String.format("UserTransaction{datetime=%s, id=%d, type=%s, mxn=%s, btc=%s, fee=%s}", new Object[]{this.datetime, this.id, this.type, this.mxn, this.btc, this.fee});
    }

    public static enum TransactionType {
        deposit,
        withdrawal,
        trade,
        type3_reserved,
        type4_reserved,
        type5_reseverd,
        type6_reseved,
        type7_reserved;

    }
}

