/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.dto.trade;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.bitso.BitsoUtils;
import org.knowm.xchange.bitso.dto.trade.BitsoErrorDeserializer;

public final class BitsoOrder {
    private final String id;
    private final String datetime;
    private final int type;
    private final BigDecimal price;
    private final BigDecimal amount;
    private final String errorMessage;

    public BitsoOrder(@JsonProperty(value="id") String id, @JsonProperty(value="datetime") String datetime, @JsonProperty(value="type") int type, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="error") @JsonDeserialize(using=BitsoErrorDeserializer.class) String errorMessage) {
        this.id = id;
        this.datetime = datetime;
        this.type = type;
        this.price = price;
        this.amount = amount;
        this.errorMessage = errorMessage;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonIgnore
    public Date getTime() {
        return BitsoUtils.parseDate(this.getDatetime());
    }

    @JsonIgnore
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.errorMessage != null ? this.errorMessage : String.format("Order{id=%s, datetime=%s, type=%s, price=%s, amount=%s}", this.id, this.datetime, this.type, this.price, this.amount);
    }
}

