/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

public class BitsoTransaction {
    private final long date;
    private final int tid;
    private final BigDecimal price;
    private final BigDecimal amount;
    private final String side;

    public BitsoTransaction(@JsonProperty(value="date") long date, @JsonProperty(value="tid") int tid, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="side") String side) {
        this.date = date;
        this.tid = tid;
        this.price = price;
        this.amount = amount;
        this.side = side;
    }

    public int getTid() {
        return this.tid;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public long getDate() {
        return this.date;
    }

    public String getSide() {
        return this.side;
    }

    public BigDecimal calculateFeeBtc() {
        return this.roundUp(this.amount.multiply(new BigDecimal("0.5"))).divide(new BigDecimal("100"));
    }

    private BigDecimal roundUp(BigDecimal x) {
        long n = x.longValue();
        return BigDecimal.valueOf(x.equals(BigDecimal.valueOf(n)) ? n : n + 1L);
    }

    public BigDecimal calculateFeeMxn() {
        return this.calculateFeeBtc().multiply(this.price);
    }

    public String toString() {
        return "Transaction [date=" + this.date + ", tid=" + this.tid + ", price=" + this.price + ", amount=" + this.amount + ", side=" + this.side + "]";
    }
}

