/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.bitso.dto.BitsoException;
import org.knowm.xchange.bitso.dto.account.BitsoBalance;
import org.knowm.xchange.bitso.dto.account.BitsoDepositAddress;
import org.knowm.xchange.bitso.dto.trade.BitsoOrder;
import org.knowm.xchange.bitso.dto.trade.BitsoUserTransaction;
import org.knowm.xchange.bitso.service.BitsoDigest;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="v2")
@Consumes(value={"application/x-www-form-urlencoded"})
@Produces(value={"application/json"})
public interface BitsoAuthenticated {
    @POST
    @Path(value="open_orders/")
    public BitsoOrder[] getOpenOrders(@FormParam(value="key") String var1, @FormParam(value="signature") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws BitsoException, IOException;

    @POST
    @Path(value="buy/")
    public BitsoOrder buy(@FormParam(value="key") String var1, @FormParam(value="signature") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") BigDecimal var4, @FormParam(value="price") BigDecimal var5) throws BitsoException, IOException;

    @POST
    @Path(value="sell/")
    public BitsoOrder sell(@FormParam(value="key") String var1, @FormParam(value="signature") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") BigDecimal var4, @FormParam(value="price") BigDecimal var5) throws BitsoException, IOException;

    @POST
    @Path(value="cancel_order/")
    public boolean cancelOrder(@FormParam(value="key") String var1, @FormParam(value="signature") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="id") String var4) throws BitsoException, IOException;

    @POST
    @Path(value="user_transactions/")
    public BitsoUserTransaction[] getUserTransactions(@FormParam(value="key") String var1, @FormParam(value="signature") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="limit") long var4) throws BitsoException, IOException;

    @POST
    @Path(value="user_transactions/")
    public BitsoUserTransaction[] getUserTransactions(@FormParam(value="key") String var1, @FormParam(value="signature") ParamsDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="limit") long var4, @FormParam(value="offset") long var6, @FormParam(value="sort") String var8) throws BitsoException, IOException;

    @POST
    @Path(value="balance/")
    public BitsoBalance getBalance(@FormParam(value="key") String var1, @FormParam(value="signature") BitsoDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws BitsoException, IOException;

    @POST
    @Path(value="bitcoin_deposit_address/")
    public BitsoDepositAddress getBitcoinDepositAddress(@FormParam(value="key") String var1, @FormParam(value="signature") BitsoDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3) throws BitsoException, IOException;

    @POST
    @Path(value="bitcoin_withdrawal/")
    public String withdrawBitcoin(@FormParam(value="key") String var1, @FormParam(value="signature") BitsoDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") BigDecimal var4, @FormParam(value="address") String var5) throws BitsoException, IOException;

    @POST
    @Path(value="ripple_withdrawal/")
    public String withdrawToRipple(@FormParam(value="key") String var1, @FormParam(value="signature") BitsoDigest var2, @FormParam(value="nonce") SynchronizedValueFactory<Long> var3, @FormParam(value="amount") BigDecimal var4, @FormParam(value="currency") String var5, @FormParam(value="address") String var6) throws BitsoException, IOException;
}

