/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitso;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.bitso.BitsoUtils;
import org.knowm.xchange.bitso.dto.account.BitsoBalance;
import org.knowm.xchange.bitso.dto.marketdata.BitsoOrderBook;
import org.knowm.xchange.bitso.dto.marketdata.BitsoTicker;
import org.knowm.xchange.bitso.dto.marketdata.BitsoTransaction;
import org.knowm.xchange.bitso.dto.trade.BitsoUserTransaction;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;

public final class BitsoAdapters {
    private BitsoAdapters() {
    }

    public static Ticker adaptTicker(BitsoTicker t, CurrencyPair currencyPair) {
        return new Ticker.Builder().currencyPair(currencyPair).last(t.getLast()).bid(t.getBid()).ask(t.getAsk()).high(t.getHigh()).low(t.getLow()).vwap(t.getVwap()).volume(t.getVolume()).timestamp(t.getTimestamp()).build();
    }

    public static Wallet adaptWallet(BitsoBalance bitsoBalance) {
        Balance mxnBalance = new Balance(Currency.MXN, bitsoBalance.getMxnBalance(), bitsoBalance.getMxnAvailable(), bitsoBalance.getMxnReserved());
        Balance btcBalance = new Balance(Currency.BTC, bitsoBalance.getBtcBalance(), bitsoBalance.getBtcAvailable(), bitsoBalance.getBtcReserved());
        return Wallet.Builder.from(Arrays.asList(mxnBalance, btcBalance)).build();
    }

    public static OrderBook adaptOrderBook(BitsoOrderBook bitsoOrderBook, CurrencyPair currencyPair, int timeScale) {
        List<LimitOrder> asks = BitsoAdapters.createOrders(currencyPair, Order.OrderType.ASK, bitsoOrderBook.getAsks());
        List<LimitOrder> bids = BitsoAdapters.createOrders(currencyPair, Order.OrderType.BID, bitsoOrderBook.getBids());
        Date date = new Date(bitsoOrderBook.getTimestamp() * (long)timeScale);
        return new OrderBook(date, asks, bids);
    }

    public static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, List<List<BigDecimal>> orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (List<BigDecimal> ask : orders) {
            BitsoAdapters.checkArgument(ask.size() == 2, "Expected a pair (price, amount) but got {0} elements.", ask.size());
            limitOrders.add(BitsoAdapters.createOrder(currencyPair, ask, orderType));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, List<BigDecimal> priceAndAmount, Order.OrderType orderType) {
        return new LimitOrder(orderType, priceAndAmount.get(1), (Instrument)currencyPair, "", null, priceAndAmount.get(0));
    }

    public static Trades adaptTrades(BitsoTransaction[] transactions, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (BitsoTransaction tx : transactions) {
            Order.OrderType type;
            switch (tx.getSide()) {
                case "buy": {
                    type = Order.OrderType.ASK;
                    break;
                }
                case "sell": {
                    type = Order.OrderType.BID;
                    break;
                }
                default: {
                    type = null;
                }
            }
            long tradeId = tx.getTid();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            trades.add(new Trade.Builder().type(type).originalAmount(tx.getAmount()).currencyPair(currencyPair).price(tx.getPrice()).timestamp(DateUtils.fromMillisUtc((long)(tx.getDate() * 1000L))).id(String.valueOf(tradeId)).build());
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static void checkArgument(boolean argument, String msgPattern, Object ... msgArgs) {
        if (!argument) {
            throw new IllegalArgumentException(MessageFormat.format(msgPattern, msgArgs));
        }
    }

    public static UserTrades adaptTradeHistory(BitsoUserTransaction[] bitsoUserTransactions) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>();
        long lastTradeId = 0L;
        for (BitsoUserTransaction bitsoUserTransaction : bitsoUserTransactions) {
            if (!bitsoUserTransaction.getType().equals((Object)BitsoUserTransaction.TransactionType.trade)) continue;
            boolean sell = bitsoUserTransaction.getMxn().doubleValue() > 0.0;
            Order.OrderType orderType = sell ? Order.OrderType.ASK : Order.OrderType.BID;
            BigDecimal originalAmount = bitsoUserTransaction.getBtc();
            BigDecimal price = bitsoUserTransaction.getPrice().abs();
            Date timestamp = BitsoUtils.parseDate(bitsoUserTransaction.getDatetime());
            long transactionId = bitsoUserTransaction.getId();
            if (transactionId > lastTradeId) {
                lastTradeId = transactionId;
            }
            String tradeId = String.valueOf(transactionId);
            String orderId = String.valueOf(bitsoUserTransaction.getOrderId());
            BigDecimal feeAmount = bitsoUserTransaction.getFee();
            CurrencyPair currencyPair = new CurrencyPair(Currency.BTC, Currency.MXN);
            String feeCurrency = sell ? currencyPair.counter.getCurrencyCode() : currencyPair.base.getCurrencyCode();
            UserTrade trade = UserTrade.builder().type(orderType).originalAmount(originalAmount).currencyPair(currencyPair).price(price).timestamp(timestamp).id(tradeId).orderId(orderId).feeAmount(feeAmount).feeCurrency(Currency.getInstance((String)feeCurrency)).build();
            trades.add(trade);
        }
        return new UserTrades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }
}

