/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcointoyou.service.polling;

import java.io.IOException;
import java.util.HashMap;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcointoyou.BitcointoyouException;
import org.knowm.xchange.bitcointoyou.dto.trade.BitcointoyouOrderResponse;
import org.knowm.xchange.bitcointoyou.service.polling.BitcointoyouBasePollingService;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitcointoyouTradeServiceRaw
extends BitcointoyouBasePollingService {
    public BitcointoyouTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public BitcointoyouOrderResponse returnOpenOrders() throws IOException {
        return this.bitcointoyouAuthenticated.returnOpenOrders(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator);
    }

    public BitcointoyouOrderResponse returnOrderById(String orderId) throws IOException {
        return this.bitcointoyouAuthenticated.returnOrderById(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator, orderId);
    }

    public BitcointoyouOrderResponse buy(LimitOrder limitOrder) throws IOException {
        return this.createOrder("buy", limitOrder);
    }

    public BitcointoyouOrderResponse sell(LimitOrder limitOrder) throws IOException {
        return this.createOrder("sell", limitOrder);
    }

    private BitcointoyouOrderResponse createOrder(String action, LimitOrder limitOrder) throws IOException {
        try {
            String asset = limitOrder.getCurrencyPair().base.getSymbol();
            return this.bitcointoyouAuthenticated.createOrder(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator, asset, action, limitOrder.getOriginalAmount(), limitOrder.getLimitPrice());
        }
        catch (BitcointoyouException e) {
            throw new ExchangeException(e.getError());
        }
    }

    public boolean cancel(String orderId) throws IOException {
        HashMap<String, String> response = this.bitcointoyouAuthenticated.deleteOrder(this.apiKey, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.signatureCreator, orderId);
        if (response.containsKey("error")) {
            throw new ExchangeException(response.get("error"));
        }
        return response.get("success").equals("1");
    }
}

