/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcointoyou.service.polling;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcointoyou.BitcointoyouAdapters;
import org.knowm.xchange.bitcointoyou.dto.trade.BitcointoyouOrderResponse;
import org.knowm.xchange.bitcointoyou.service.polling.BitcointoyouTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsAll;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;

public class BitcointoyouTradeService
extends BitcointoyouTradeServiceRaw
implements TradeService {
    public BitcointoyouTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        BitcointoyouOrderResponse bitcointoyouOpenOrders = this.returnOpenOrders();
        return BitcointoyouAdapters.adaptBitcointoyouOpenOrders(bitcointoyouOpenOrders);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        if (limitOrder.getType() == Order.OrderType.BID) {
            BitcointoyouOrderResponse buy = this.buy(limitOrder);
            if (buy.getOrderList() != null && !buy.getOrderList().isEmpty()) {
                return buy.getOrderList().get(0).getId();
            }
        } else {
            BitcointoyouOrderResponse sell = this.sell(limitOrder);
            if (sell.getOrderList() != null && !sell.getOrderList().isEmpty()) {
                return sell.getOrderList().get(0).getId();
            }
        }
        return null;
    }

    public boolean cancelOrder(String orderId) throws IOException {
        return this.cancel(orderId);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        return false;
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new BitcointoyouTradeHistoryParams();
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        if (orderQueryParams.length == 1) {
            return BitcointoyouAdapters.adaptBitcointoyouOrderToOrdersCollection(this.returnOrderById(orderQueryParams[0].getOrderId()));
        }
        throw new NotAvailableFromExchangeException();
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotAvailableFromExchangeException();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        throw new NotAvailableFromExchangeException();
    }

    public static class BitcointoyouTradeHistoryParams
    implements TradeHistoryParamCurrencyPair,
    TradeHistoryParamsTimeSpan {
        private final TradeHistoryParamsAll all = new TradeHistoryParamsAll();

        public CurrencyPair getCurrencyPair() {
            return this.all.getCurrencyPair();
        }

        public void setCurrencyPair(CurrencyPair value) {
            this.all.setCurrencyPair(value);
        }

        public Date getStartTime() {
            return this.all.getStartTime();
        }

        public void setStartTime(Date value) {
            this.all.setStartTime(value);
        }

        public Date getEndTime() {
            return this.all.getEndTime();
        }

        public void setEndTime(Date value) {
            this.all.setEndTime(value);
        }
    }
}

