/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcointoyou.service.polling;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcointoyou.BitcointoyouException;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouMarketData;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouOrderBook;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouPublicTrade;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouTicker;
import org.knowm.xchange.bitcointoyou.service.polling.BitcointoyouBasePollingService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;

class BitcointoyouMarketDataServiceRaw
extends BitcointoyouBasePollingService {
    BitcointoyouMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    BitcointoyouTicker getBitcointoyouTicker(CurrencyPair currencyPair) throws IOException {
        Map<String, BitcointoyouMarketData> marketData;
        try {
            marketData = this.bitcointoyou.getTicker();
        }
        catch (BitcointoyouException e) {
            throw new ExchangeException(e.getError());
        }
        BitcointoyouMarketData data = null;
        if (marketData != null && !marketData.isEmpty()) {
            data = marketData.entrySet().iterator().next().getValue();
        }
        if (data == null) {
            throw new ExchangeException(currencyPair + " not available");
        }
        return new BitcointoyouTicker(data, currencyPair);
    }

    BitcointoyouOrderBook getBitcointoyouOrderBook() throws IOException {
        try {
            return this.bitcointoyou.getOrderBook();
        }
        catch (BitcointoyouException e) {
            throw new ExchangeException(e.getMessage(), (Throwable)e);
        }
    }

    BitcointoyouPublicTrade[] getBitcointoyouPublicTrades(CurrencyPair currencyPair) throws IOException {
        try {
            return this.getBitcointoyouPublicTrades(currencyPair, null, null);
        }
        catch (BitcointoyouException e) {
            throw new ExchangeException(e.getError());
        }
    }

    BitcointoyouPublicTrade[] getBitcointoyouPublicTrades(CurrencyPair currencyPair, Long tradeTimestamp, Long minTradeId) throws IOException {
        String currency = currencyPair.base.toString();
        try {
            return this.bitcointoyou.getTrades(currency, tradeTimestamp, minTradeId);
        }
        catch (BitcointoyouException e) {
            throw new ExchangeException(e.getError());
        }
    }
}

