/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcointoyou.service.polling;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcointoyou.BitcointoyouAdapters;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouOrderBook;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouPublicTrade;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouTicker;
import org.knowm.xchange.bitcointoyou.service.polling.BitcointoyouMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcointoyouMarketDataService
extends BitcointoyouMarketDataServiceRaw
implements MarketDataService {
    public BitcointoyouMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        BitcointoyouTicker bitcointoyouTicker = this.getBitcointoyouTicker(currencyPair);
        return BitcointoyouAdapters.adaptBitcointoyouTicker(bitcointoyouTicker, currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws ExchangeException, IOException {
        BitcointoyouOrderBook ob = this.getBitcointoyouOrderBook();
        return BitcointoyouAdapters.adaptBitcointoyouOrderBook(ob, currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws ExchangeException, IOException {
        Long tradeTimeStamp = null;
        Long minTradeId = null;
        if (args != null) {
            switch (args.length) {
                case 2: {
                    if (args[1] != null && args[1] instanceof Long) {
                        minTradeId = (Long)args[1];
                    }
                }
                case 1: {
                    if (args[0] == null || !(args[0] instanceof Long)) break;
                    tradeTimeStamp = (Long)args[0];
                }
            }
        }
        BitcointoyouPublicTrade[] bitcointoyouPublicTrades = tradeTimeStamp == null && minTradeId == null ? this.getBitcointoyouPublicTrades(currencyPair) : this.getBitcointoyouPublicTrades(currencyPair, tradeTimeStamp, minTradeId);
        return BitcointoyouAdapters.adaptBitcointoyouPublicTrades(bitcointoyouPublicTrades, currencyPair);
    }
}

