/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcointoyou.dto.trade;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"asset", "currency", "id", "action", "status", "price", "amount", "executedPriceAverage", "executedAmount", "dateCreated"})
public class BitcointoyouOrderInfo {
    private final String asset;
    private final String currency;
    private final String id;
    private final String action;
    private final String status;
    private final BigDecimal price;
    private final BigDecimal amount;
    private final String executedPriceAverage;
    private final String executedAmount;
    private final String dateCreated;
    @JsonIgnore
    private final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonIgnore
    private String content;

    @JsonCreator
    public BitcointoyouOrderInfo(String content) {
        this.content = content;
        this.asset = null;
        this.currency = null;
        this.id = null;
        this.action = null;
        this.status = null;
        this.price = null;
        this.amount = null;
        this.executedPriceAverage = null;
        this.executedAmount = null;
        this.dateCreated = null;
    }

    @JsonCreator
    public BitcointoyouOrderInfo(@JsonProperty(value="asset") String asset, @JsonProperty(value="currency") String currency, @JsonProperty(value="id") String id, @JsonProperty(value="action") String action, @JsonProperty(value="status") String status, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="executedPriceAverage") String executedPriceAverage, @JsonProperty(value="executedAmount") String executedAmount, @JsonProperty(value="dateCreated") String dateCreated) {
        this.asset = asset;
        this.currency = currency;
        this.id = id;
        this.action = action;
        this.status = status;
        this.price = price;
        this.amount = amount;
        this.executedPriceAverage = executedPriceAverage;
        this.executedAmount = executedAmount;
        this.dateCreated = dateCreated;
    }

    @JsonCreator
    public BitcointoyouOrderInfo(Map<String, String> map) {
        this.asset = map.get("asset");
        this.currency = map.get("currency");
        this.id = map.get("id");
        this.action = map.get("action");
        this.status = map.get("status");
        String priceAsString = map.get("price");
        this.price = priceAsString != null && !priceAsString.isEmpty() ? new BigDecimal(priceAsString) : null;
        String amountAsString = map.get("amount");
        this.amount = amountAsString != null && !amountAsString.isEmpty() ? new BigDecimal(amountAsString) : null;
        this.executedPriceAverage = map.get("executedPriceAverage");
        this.executedAmount = map.get("executedAmount");
        this.dateCreated = map.get("dateCreated");
    }

    @JsonIgnore
    public String getContent() {
        return this.content;
    }

    @JsonIgnore
    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="asset")
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="action")
    public String getAction() {
        return this.action;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="price")
    public BigDecimal getPrice() {
        return this.price;
    }

    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="executedPriceAverage")
    public String getExecutedPriceAverage() {
        return this.executedPriceAverage;
    }

    @JsonProperty(value="executedAmount")
    public String getExecutedAmount() {
        return this.executedAmount;
    }

    @JsonProperty(value="dateCreated")
    public String getDateCreated() {
        return this.dateCreated;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

